﻿// MathExtensions.pas
unit MathExtensions;

interface

uses System;

type
   int = integer;
   bool = boolean;


function GetFibo(): sequence of BigInteger;
function GetFiboMax(maxf: int): sequence of int;
function GetFiboMaxBI(maxf: BigInteger): sequence of BigInteger;
function GetFiboN(num: int): sequence of BigInteger;

function GetFactN(num: int): sequence of BigInteger;
function Factorial(num: integer): integer;

function IsQuadrat(num: decimal): boolean;

function Permutation(n: integer): array[,] of integer;

/// <summary>Целое число в целую степень (включая отрицательную)</summary>
//function Power(n: integer; exponent: integer): real;
    
implementation

function FastPower(base: real; exp: integer): real;
begin
  if exp = 0 then Result := 1
  else if exp mod 2 = 0 then 
    Result := FastPower(base * base, exp div 2)
  else 
    Result := base * FastPower(base, exp - 1);
end;
function Power(self: real; exponent: integer := 2): real; extensionmethod;
begin
  if (self = 0) and (exponent <= 0) then
    raise new System.ArgumentException('Недопустимая операция 0^' + exponent);
  
  if exponent = 0 then Result := 1
  else if exponent > 0 then Result := FastPower(self, exponent)
  else Result := 1 / FastPower(self, -exponent);
end;

// МЕТОДЫ РАСШИРЕНИЯ ДЛЯ КЛАССА INTEGER

// МЕТОД РАСШИРЕНИЯ ДЛЯ ТИПА int
// ВОЗВРАЩАЕТ ЧИСЛО num В СТЕПЕНИ exponent
function IPower(self: integer; exponent: integer := 2): int64; extensionmethod;
begin
   var pow: int64 := 1;
   loop exponent do pow *= self;
           Result := pow;
end;
        
{
function IPower(self: integer; exponent: integer := 2)
begin
  if (self = 0) and (exponent <= 0) then
    raise new System.ArgumentException('Недопустимая операция 0^' + exponent);
  
  if exponent = 0 then Result := 1
  else Result := FastPower(self, exponent)
end;
}


//ОПРЕДЕЛЯЕМ ЯВЛЯЕТСЯ ЛИ ЗАДАННОЕ ЧИСЛО 
//ПОЛНЫМ КВАДРАТОМ

{function int64.IsQuadrat(): boolean;
begin
   var r := Trunc(Math.Sqrt(self));
   Result := r * r = self;
end;}

function IsQuadrat(Self: int64): bool; extensionmethod;
begin
   var r := Trunc(Sqrt(self));
   Result := r * r = self;
end;

function ISqrt(Self: int64): int64; extensionmethod;
begin
   Result := Trunc(Sqrt(self));
end;

{function int.IsQuadrat(): boolean;
begin
   var r := Trunc(Math.Sqrt(self));
   Result := r * r = self;
end;
}
function IsQuadrat(Self: integer): boolean; extensionmethod;
begin
   var r := Trunc(Sqrt(self));
   Result := r * r = self;
end;



//ОПРЕДЕЛЯЕМ ЯВЛЯЕТСЯ ЛИ ЗАДАННОЕ ЧИСЛО 
//ПОЛНЫМ КВАДРАТОМ
function IsQuadrat(num: decimal): boolean;
begin
   var r := Trunc(Sqrt(double(num)));
   Result := r * r = num;
end;

//ОПРЕДЕЛЯЕМ ЯВЛЯЕТСЯ ЛИ ЗАДАННОЕ ЧИСЛО 
//ПОЛНЫМ КУБОМ
{function int64.IsCube(): boolean;
begin
   var r := Trunc(Math.Round(Math.Pow(self, 1.0 / 3.0)));
   Result := r * r * r = self;
end;}

function IsCube(Self: int64): boolean; extensionmethod;
begin
   var r := Trunc(Round(Power(self, 1.0 / 3.0)));
   Result := r * r * r = self;
end;

{function int.IsCube(): boolean;
begin
   var r := Trunc(Math.Round(Math.Pow(self, 1.0 / 3.0)));
   Result := r * r * r = self;
end;}

function IsCube(Self: integer): boolean; extensionmethod;
begin
   var r := Trunc(Round(Power(self, 1.0 / 3.0)));
   Result := r * r * r = self;
end;


// целое число?
function IsInteger(Self: real): boolean; extensionmethod;
begin
   Result := self = Trunc(self);
end;


//  ЧИСЛА-ПАЛИНДРОМЫ
function int64.IsPalindrome(): boolean;
begin
  	//избавляемся от чисел, заканчивающихся на нуль:
   if ((self <> 0) and (self mod 10 = 0)) then
   begin
      Result := false;
      exit;
   end;
   
   var rev: int64 := 0;
   var num := self;
   while (num >= rev) do
   begin
      rev := 10 * rev + num mod 10;		
      if (num = rev) then
      begin
         Result := true;
         exit;
      end;
      
      num := num div 10;
      if (num = rev) then
      begin
         Result := true;
         exit;
      end;
   end;
   Result := false;
end;

function IsPalindrome(Self: integer): boolean; extensionmethod;
begin
  	// избавляемся от чисел, заканчивающихся на нуль:
   if ((self <> 0) and (self mod 10 = 0)) then
   begin
      Result := false;
      exit;
   end;
   
   var rev := 0;
   var num := self;
   while (num >= rev) do
   begin
      rev := 10 * rev + num mod 10;		
      if (num = rev) then
      begin
         Result := true;
         exit;
      end;
      
      num := num div 10;
      if (num = rev) then
      begin
         Result := true;
         exit;
      end;
   end;
   Result := false;
end;


function BigInteger.IsPalindrome(): bool;
begin
   var rev: BigInteger := 0;
   var num := self;
   while (num >= rev) do
   begin
      rev := 10 * rev + num mod 10;
      if (num = rev) then
      begin
         Result := true;
         exit;
      end;
      
      num := num div 10;
      
      if (num = rev) then
      begin
         Result := true;
         exit;
      end;
   end;
   Result := false;
end;


// ПЕРЕВОРАЧИВАЕМ ЧИСЛО
function ReverseNum(Self: integer): integer; extensionmethod;
begin
   var rev := 0;
   var num := self;    
   while (num > 0) do
   begin
      rev := rev * 10 + num mod 10;
      num := num div 10;
   end;
   Result := rev;
end;

function ReverseNum(Self: BigInteger): BigInteger; extensionmethod;
begin
   var rev: BigInteger := 0;
   var num := self;    
   while (num > 0) do
   begin
      rev := rev * 10 + num mod 10;
      num := num div 10;
   end;
   Result := rev;
end;




// НАХОДИМ ЧИСЛО ЦИФР В ЗАДАННОМ ЧИСЛЕ
function NumDigit(Self: int64): integer; extensionmethod;
begin
   var num := Abs(self);
   var nd := 0;
   while (num > 0) do
   begin
      nd += 1;
      num := num div 10;
   end;
   Result := Max(1, nd);
end;

function NumDigit(Self: integer): integer; extensionmethod;
begin
   var num := Abs(self);
   var nd := 0;
   while (num > 0) do
   begin
      nd += 1;
      num := num div 10;
   end;
   Result := Max(1, nd);
end;

// ВСЕ ЦИФРЫ ЗАДАННОГО ЧИСЛА
{function GetDigits(Self: integer): sequence of integer; extensionmethod;
begin
   var num := Abs(self);
   while (num > 0) do
   begin
      var dig:= num mod 10;
      num := num div 10;     
      yield dig;
   end;
end;}

function GetDigits(Self: integer): sequence of integer; extensionmethod;
begin
   var res := Range(0,-1);
   var num := Abs(self);
   while (num > 0) do
   begin
      var dig:= num mod 10;
      num := num div 10;     
      res := res + dig;
   end;
   Result := res.Reverse;
end;


// ПРОВЕРЯЕМ ЧИСЛО НА ПРОСТОТУ
function IsPrime(Self: integer): bool; extensionmethod;
begin
   var num := self;
   if num > 1 then  begin
      Result := Range(2, Trunc(Sqrt(num)))
               .All(divisor -> num mod divisor <> 0)
   end
   else Result := false;
end;


//                ФАКТОРИЗАЦИЯ
{
// ПРОСТЫЕ ДЕЛИТЕЛИ
// без повторения одинаковых делителей!
function GetPrimeFactors(Self: integer): sequence of int; extensionmethod;
begin
   var num := self;
   Result := PABCSystem.Range(2, Trunc(Sqrt(num)))
                       .Where(divisor -> (num mod divisor = 0) and (divisor.IsPrime))
end;

function int64.GetPrimeFactors(): sequence of int;
begin
   var num := self;   
   Result := PABCSystem.Range(2, Trunc(Sqrt(num)))
                       .Where(divisor -> (num mod divisor = 0) and (divisor.IsPrime))
end;
}
{
function GetPrimeFactorsRep(Self: integer): sequence of int; extensionmethod;
begin
   var factors := new List<int>();
   var n := Self;
   if (n = 1) then
       factors.Add(1)
   else
   begin
      var factor := 2;
      var step := 2;

      while (factor * factor <= n) do
      begin
         if (n mod factor = 0) then
         begin
            factors.Add(factor);
            n := factor;
         end
         else if (factor < 3) then
         begin
            factor += 1;
         end
         else if (factor < 5) then
         begin
            factor += 2;
         end
         else
         begin
            factor += step;
            step := 6 - step;
         end;
      end;
      factors.Add(n);
   end;
   Result:= factors;
end;
}

// ПРОСТЫЕ ДЕЛИТЕЛИ
// с повторением одинаковых делителей!
function GetPrimeFactorsRep(Self: integer): sequence of int; extensionmethod;
begin   
   var n := Self;
   if (n = 1) then
       yield 1
   else
   begin
      var factor := 2;
      var step := 2;

      while (factor * factor <= n) do
      begin
         if (n mod factor = 0) then
         begin
            yield factor;
            n := n div factor;
         end
         else if (factor < 3) then
         begin
            factor += 1;
         end
         else if (factor < 5) then
         begin
            factor += 2;
         end
         else
         begin
            factor += step;
            step := 6 - step;
         end;
      end;
      yield n;
   end;
end;
     

// ВСЕ ДЕЛИТЕЛИ
// без повторения одинаковых делителей!
function GetFactors(Self: integer): sequence of int; extensionmethod;
begin
   var num := self;   
   Result := PABCSystem.Range(2, Trunc(Sqrt(num)))
                       .Where(divisor -> num mod divisor = 0)
end;

function int64.GetFactors(): sequence of int;
begin
   var num := self;   
   Result := PABCSystem.Range(2, Trunc(Sqrt(num)))
                       .Where(divisor -> num mod divisor = 0)
end;



//          ЧИСЛА ФИБОНАЧЧИ

function GetFibo(): sequence of BigInteger;
begin
   var a: BigInteger := 0;
   var b: BigInteger := 1;
   while true do
   begin
      yield a;
      (a, b) := (b, a + b);
   end;
end;

function GetFiboMaxBI(maxf: BigInteger): sequence of BigInteger;
begin
   var a: BigInteger := 0;
   var b: BigInteger := 1;
   while (a <= maxf) do
   begin
      yield a;
      (a, b) := (b, a + b);
   end;
end;

function GetFiboMax(maxf: int): sequence of int;
begin
   var a: int := 0;
   var b: int := 1;
   while (a <= maxf) do
   begin
      yield a;
      (a, b) := (b, a + b);
   end;
end;

function GetFiboN(num: int): sequence of BigInteger;
begin
   var a: BigInteger := 0;
   var b: BigInteger := 1;
   foreach var i in Range(1, num) do
   begin
      yield a;
      (a, b) := (b, a + b);
   end;
end;


// ВЫЧИСЛЯЕМ ФАКТОРИАЛ
function GetFactN(num: int): sequence of BigInteger;
begin
   var n: BigInteger := 1;
   foreach var i in Range(1, num) do
   begin
      n := i * n;
      yield n;
   end;
end;


function Factorial(num: integer): integer;
begin
   var fact := 1;
   for var i := 1 to num do
      fact *= i;	
   
   Result := fact;
end;

function Factorial(Self: integer): integer; extensionmethod;
begin
   var fact := 1;
   for var i := 1 to Self do
      fact *= i;	
   
   Result := fact;
end;





// ТРЕУГОЛЬНЫЕЧИСЛА
{
// НЕРЕКУРСИВНАЯ ФУНКЦИЯ
function tri2(n : int): BigInteger;
begin
    if (n <= 1) then
    begin
        Result := n;
        exit;
    end;

    Result := n * (n + 1) div 2;
end;
}

//    ПЕРЕСТАНОВКИ

//ГЕНЕРИРУЕМ ПЕРЕСТАНОВКИ
function Permutation(n: integer): array[,] of integer;
begin
   //число перестановок:
   var AllPerm := Factorial(n);
   //массив перестановок:
   var perms := new integer[AllPerm, n];
   
   //текущее число перестановок:
   var nPerm := 0;
   
   //массив чисел:
   var a := new integer[n + 2];
   //начальная перестановка:
   for var e := 1 to n do
      a[e] := e;
   
   var j: integer;
   repeat
      for var id := 1 to n do
         perms[nPerm, id - 1] := a[id];
      
      nPerm += 1;     
      var i := n;
      while (a[i - 1] > a[i]) do 
         i -= 1;
      j := i - 1;
      var h := a[j];
      
      while (a[i + 1] > h) do
         i += 1;
      a[j] := a[i];  
      a[i] := h;
      i := j + 1; 
      var k := n;
      while (i < k) do
      begin
         h := a[i]; 
         a[i] := a[k]; 
         a[k] := h;
         i += 1;
         k -= 1;               
      end
   until not (j <> 0);
   
   Result := perms;
end;



// ПЕЧАТАЕМ ЧИСЛО ТИПА integer
{
function Println(Self: integer): integer; extensionmethod;
begin
   Println(Self);   
   Result := Self;
end;

// ПЕЧАТАЕМ ЧИСЛО ТИПА BigInteger
function Println(Self: BigInteger): BigInteger; extensionmethod;
begin
   Println(Self);   
   Result := Self;
end;

// ПЕЧАТАЕМ ЧИСЛО ТИПА int64
function Println(Self: int64): int64; extensionmethod;
begin
   Println(Self);   
   Result := Self;
end;
}
// ПЕЧАТАЕМ СПИСОК
function Println<T>(Self: List<T>): List<T>; extensionmethod;
begin
   Println(Self);   
   Result := Self;
end;

/// Декартово произведение двух последовательностей
/// к каждой паре элементов этих последовательностей
/// применяется функция resultSelector
function Cartesian<T, T1>(Self: sequence of T; 
                         b: sequence of T1;
                         resultSelector: Func<T, T1, T> ): sequence of T; extensionmethod;
begin
   if b = nil then
      raise new System.ArgumentNullException('b');
   if (resultSelector = nil) then
      raise new System.ArgumentNullException('resultSelector');
   
   foreach var x in Self do
      foreach var y in b do
         yield resultSelector(x, y)
end;

// ВОЗВРАЩАЕТ КВАДРАТЫ ЧИСЕЛ
function Squares(Self: sequence of integer): sequence of int64; extensionmethod;
begin
   foreach var i in Self do
      yield int64(i) * i;
end;

// ВОЗВРАЩАЕТ КУБЫ ЧИСЕЛ
function Cubes(Self: sequence of integer): sequence of int64; extensionmethod;
begin
   foreach var i in Self do
      yield int64(i) * i * i;
end;

{function Where64(Self: sequence of int64; predicat: System.Func<int64,Boolean>): sequence of int64; extensionmethod;
begin
   foreach var i in Self do
      if predicat(i) then
         yield i;
end;}

end.
