﻿unit PascalMathNet;

interface

{$reference MathNet.Numerics.dll}
// Подключаем пространство имен для линейной алгебры:
uses MathNet.Numerics.LinearAlgebra;

type
  TMatrix = Matrix<real>;
  TVector = Vector<real>;

  MathNetPascal = static class
    
    // Создаём матрицу:
    class function Mat2(a11, a12, a21, a22: real): TMatrix;
    class function Mat3(a11, a12, a13, a21, a22, a23, a31, a32, a33: real): TMatrix;   
    
    // Создаём вектор:
    class function Vec2(x, y: real): TVector;
    class function Vec3(x, y, z: real): TVector;   
    
    // Решаем систему:
    class function Solve2(a11, a12, a21, a22, b1, b2: real): (real, real);
    class function Solve3(a11, a12, a13, a21, a22, a23, a31, a32, a33, b1, b2, b3: real): (real, real, real); 
    
    // Печатаем матрицу:
    class procedure PrintMatrix(A: TMatrix);
  end;

implementation

class function MathNetPascal.Mat2(a11, a12, a21, a22: real): TMatrix;
begin
  Result := TMatrix.Build.DenseOfRowArrays(
    new real[] (a11, a12),
    new real[] (a21, a22)
  );
end;

class function MathNetPascal.Mat3(a11, a12, a13, a21, a22, a23, a31, a32, a33: real): TMatrix;
begin
  Result := TMatrix.Build.DenseOfRowArrays(
    new real[] (a11, a12, a13),
    new real[] (a21, a22, a23),
    new real[] (a31, a32, a33)    
  );
end;


class function MathNetPascal.Vec2(x, y: real): TVector;
begin
  Result := TVector.Build.DenseOfArray(new real[] (x, y));
end;

class function MathNetPascal.Vec3(x, y, z: real): TVector;
begin
  Result := TVector.Build.DenseOfArray(new real[] (x, y, z));
end;

class function MathNetPascal.Solve2(a11, a12, a21, a22, b1, b2: real): (real, real);
begin
  var A := Mat2(a11, a12, a21, a22);
  var b := Vec2(b1, b2);
  var x := A.Solve(b);
  Result := (x[0], x[1]);
end;

class function MathNetPascal.Solve3(a11, a12, a13, a21, a22, a23, a31, a32, a33, b1, b2, b3: real): (real, real, real);
begin
  var A := Mat3(a11, a12, a13, a21, a22, a23, a31, a32, a33);
  var b := Vec3(b1, b2, b3);
  var x := A.Solve(b);
  Result := (x[0], x[1], x[3]);
end;


class procedure MathNetPascal.PrintMatrix(A: TMatrix);
begin
  for var i := 0 to A.RowCount - 1 do
  begin
    Write('[');
    for var j := 0 to A.ColumnCount - 1 do
    begin
      Write(A[i, j]:10:4);
      if j < A.ColumnCount - 1 then Write(', ');
    end;
    WriteLn(']');
  end;
end;

end.
