﻿uses GraphABC;

procedure DrawTemperatureGraph;
const
  CMin = -50;  // Минимальная температура по Цельсию
  CMax = 100;  // Максимальная температура по Цельсию
  Width = 800;
  Height = 600;
  
  function CelsiusToFahrenheit(c: real): real;
  begin
    Result := c * 9/5 + 32;
  end;
  
  function GetX(value, min, max: real): integer;
  begin
    Result := Round(50 + (value - min) * (Width - 100) / (max - min));
  end;
  
  function GetY(value, min, max: real): integer;
  begin
    Result := Round(Height - 50 - (value - min) * (Height - 100) / (max - min));
  end;

begin
  // Создаем окно
  SetWindowSize(Width, Height);
  SetWindowTitle('Графики температур: Цельсий и Фаренгейт');
  
  // Фон
  ClearWindow(clWhite);
  SetPenColor(clBlack);
  SetPenWidth(1);
  
  // Рисуем оси
  Line(50, 50, 50, Height - 50);  // Ось Y
  Line(50, Height - 50, Width - 50, Height - 50);  // Ось X
  
  // Подписи осей
  TextOut(20, 20, 'Температура');
  TextOut(Width - 30, Height - 30, '°C');
  
  // Разметка оси X (Цельсий)
  for var c := CMin to CMax step 10 do
  begin
    var x := GetX(c, CMin, CMax);
    Line(x, Height - 45, x, Height - 55);
    TextOut(x - 10, Height - 40, c.ToString);
  end;
  
  // Вторая ось Y (Фаренгейт справа)
  SetPenColor(clGray);
  Line(Width - 50, 50, Width - 50, Height - 50);
  TextOut(Width - 40, 20, '°F');
  
  // Разметка оси Y справа (Фаренгейт)
  for var f := -58 to 212 step 20 do
  begin
    var y := GetY(f, -58, 212);
    Line(Width - 55, y, Width - 45, y);
    TextOut(Width - 70, y - 5, f.ToString);
  end;
  
  // График Фаренгейта как функция от Цельсия (синяя линия)
  SetPenColor(clBlue);
  SetPenWidth(2);
  
  var prevPoint := true;
  var cr := CMin  + 0.0;
  while cr <= CMax do begin
    var f := CelsiusToFahrenheit(cr);
    var x := GetX(cr, CMin, CMax);
    var y := GetY(f, -58, 212);
    
    if prevPoint then
      MoveTo(x, y)
    else
      LineTo(x, y);
    prevPoint := false;
    cr += 0.1;
  end;
  
  // Линия y = x (красная пунктирная) - для сравнения
  SetPenColor(clRed);
  SetPenWidth(2);
  
  prevPoint := true;
  for var c := CMin to CMax step 1 do
  begin
    var x := GetX(c, CMin, CMax);
    var y := GetY(c, -58, 212);
    
    if prevPoint then
      MoveTo(x, y)
    else
      LineTo(x, y);
    prevPoint := false;
  end;
  
  // Легенда
  SetPenStyle(psSolid);
  SetBrushColor(clWhite);
  Rectangle(Width - 700, 70, Width - 560, 120);
  
  SetPenColor(clBlue);
  SetPenWidth(2);
  Line(Width - 690, 85, Width - 660, 85);
  TextOut(Width - 650, 78, 'Фаренгейт');
  
  SetPenColor(clRed);
  Line(Width - 690, 105, Width - 660, 105);
  TextOut(Width - 650, 98, 'Цельсий');
  
  // Точки перехода через ноль
  SetBrushColor(clGreen);
  Circle(GetX(0, CMin, CMax), GetY(32, -58, 212), 4);
  TextOut(GetX(0, CMin, CMax) + 10, GetY(32, -58, 212) - 10, '0°C = 32°F');
  
  // Точка, где шкалы совпадают
  var matchPoint := -40;
  SetBrushColor(clBlue);
  Circle(GetX(matchPoint, CMin, CMax), 
         GetY(matchPoint, -58, 212), 4);
  TextOut(GetX(matchPoint, CMin, CMax) + 10, 
          GetY(matchPoint, -58, 212) - 10, '-40°C = -40°F');
end;

begin
  DrawTemperatureGraph;
end.