﻿
function Calculate(a, b: real; op: string): real;
begin
  case op of
    '+': Result := a + b;
    '-': Result := a - b;
    '*': Result := a * b;
    '/': 
      if b <> 0 then 
        Result := a / b
      else 
        raise new Exception('Деление на ноль!');
    '^': Result := Power(a, b);   
    else raise new Exception('Неизвестная операция: ' + op);
  end;
end;

procedure Calculator;
begin
  var a, b: real;
  var op: string;
  
  while true do
  begin
    //Writeln('Для выхода введите 0');
    
    Write('>>> ');
    var input := ReadString.Trim;    
    var parts := input.ToWords();
    if parts.Length <> 3 then
    begin
      Writeln('Ошибка: нужно ввести "число операция число"');
      continue;
    end;
    
    try
      a := real.Parse(parts[0]);
      op := parts[1];//[1];
      var ops := op;
      //   Writeln($' op:  {op}')  ;   
      if op = '**' then op := '^';
      b := real.Parse(parts[2]);
      
      var result := Calculate(a, b, op);
      Writeln($' {a} {ops} {b} = {result}');
    except
      on e: Exception do
        Writeln('Ошибка: ', e.Message);
    end;
    Writeln;
  end;
end;

// Основная программа
begin
  
   Writeln('КАЛЬКУЛЯТОР');
   Writeln('=================================================');
   Writeln('Введите выражение в формате: число операция число');
   Writeln('Например: 5 + 3, 2 * 4, 10 / 2, 2 ^ 3');
   Writeln('Операции: + - * / ^ **');
   Writeln();   
   Calculator;
end.