﻿function SimpleEval(expr: string): real;
begin
  // Удаляем пробелы и заменяем ** на ^
  expr := expr.Replace(' ', '').Replace('**', '^');
  
  // Ищем операцию с самым низким приоритетом (сначала + и -)
  var pos := expr.LastIndexOfAny(['+', '-']);
  if pos > 0 then
  begin
    var left := SimpleEval(expr.Substring(0, pos));
    var right := SimpleEval(expr.Substring(pos + 1));
    case expr[pos] of
      '+': Result := left + right;
      '-': Result := left - right;
    end;
    exit;
  end;
  
  // Затем * и /
  pos := expr.LastIndexOfAny(['*', '/']);
  if pos > 0 then
  begin
    var left := SimpleEval(expr.Substring(0, pos));
    var right := SimpleEval(expr.Substring(pos + 1));
    case expr[pos] of
      '*': Result := left * right;
      '/': Result := left / right;
    end;
    exit;
  end;
  
  // Затем ^ (степень)
  pos := expr.LastIndexOf('^');
  if pos > 0 then
  begin
    var left := SimpleEval(expr.Substring(0, pos));
    var right := SimpleEval(expr.Substring(pos + 1));
    Result := Power(left, right);
    exit;
  end;
  
  // Если нет операций, это число
  Result := real.Parse(expr);
end;

begin
  println('2+3*4 = ', SimpleEval('2+3*4'));         // 14
  println('2**3 = ', SimpleEval('2**3'));           // 8
  //println('2**3 + 4 = ', SimpleEval('2**3 + 4'));           // 8 
  {
  while true do
  begin    
    Write('>>> ');
    var input := ReadString;  
    println(input);     
    println(SimpleEval(input));  
    Writeln;
  end;
  }
end.
