﻿function GetMinCoins(coins: array of integer; amount: integer; var usedCoins: array of integer): boolean;
var
  dp: array of integer;
  prev: array of integer; // для восстановления решения
  i, c: integer;
begin
  SetLength(dp, amount + 1);
  SetLength(prev, amount + 1);
  
  // Инициализация
  for i := 1 to amount do
    dp[i] := MaxInt; // "бесконечность"
  dp[0] := 0;
  
  // Динамическое программирование
  for i := 1 to amount do
    foreach c in coins do
      if (c <= i) and (dp[i - c] <> MaxInt) and (dp[i - c] + 1 < dp[i]) then
      begin
        dp[i] := dp[i - c] + 1;
        prev[i] := c;
      end;
  
  // Проверка, есть ли решение
  if dp[amount] = MaxInt then
  begin
    Result := false;
    Exit;
  end;
  
  // Восстановление набора монет
  var temp := new List<integer>;
  var cur := amount;
  while cur > 0 do
  begin
    temp.Add(prev[cur]);
    cur -= prev[cur];
  end;
  
  usedCoins := temp.ToArray;
  Result := true;
end;

begin
  var coins := Arr(1, 3, 4);
  var amount := 6;
  
  var resultCoins: array of integer;
  if GetMinCoins(coins, amount, resultCoins) then
  begin
    Writeln('Оптимальные монеты для суммы ', amount, ': ', string.Join(' + ', resultCoins));
    Writeln('Количество монет: ', Length(resultCoins));
  end
  else
    Writeln('Невозможно набрать сумму ', amount, ' указанными монетами.');
end.