﻿uses MathExtensions;

function IsPalindrome(w : string): bool;
begin
   var flg := true;
   var len := w.Length;

   // слово-палиндром?
   for var i := 1 to len div 2 do begin
      var ch1 := w[len-i+1];
      var ch2 := w[i];
      // не палиндром:      
      if (ch1 <> ch2) then
          exit(false);
   end;
   Result := flg;
end;


function GetLenNum(num: int): int;
begin
    num := Abs(num);
    var len := Trunc(Log10(num)) + 1;
    Result := len;
end;


function GetDigits(num: int): array of int;
begin
    var len := GetLenNum(num);
    var digits := new int[len];
    var i := 0;
    while (num > 0) do begin
        digits[i] := num mod 10;
        num := num div 10;
        i += 1;
    end;
    Result := digits;
end;


function IsPalindrome(digits: array of int): bool;
begin
   var flg := true;
   var len := digits.Length;

    // число-палиндром?
    for var i := 0 to len div 2 - 1 do begin
       var d1 := digits[len - i - 1];
       var d2 := digits[i];
       // не палиндром:       
       if (d1 <> d2) then 
           exit(false);
    end;
    Result := flg;
end;


// РЕШАЕМ ЗАДАЧУ
procedure Solve;
begin
   var nVar := 0;
   var max := 0;
   var maxi := 0;
   var maxj := 0;

   for var i :=100 to 999 do
     for var j := i to 999 do begin
        var mul := i * j;
        var digits := GetDigits(mul);
        //var smul := mul.ToString();
        //if IsPalindrome(smul) then begin
        if (IsPalindrome(digits)) then begin
            println($' {i} * {j} = {mul}');
            if (mul > max) then begin
                max := mul;
                maxi := i;
                maxj := j;
            end;
           nVar += 1;
        end;
     end;
   WriteLn($' Всего палиндромов: {nVar}');
   WriteLn; 
   WriteLn($' Наибольший палиндром: {maxi} * {maxj} = {max}');
   WriteLn;   
end;


// РЕШАЕМ ЗАДАЧУ
procedure Solve2;
begin
   var nVar := 0;
   var max := 0;
   var maxi := 0;
   var maxj := 0;

   for var i :=100 to 999 do
     for var j := i to 999 do begin
        var mul := i * j;
        if mul.IsPalindrome then begin
            println($' {i} * {j} = {mul}');
            if (mul > max) then begin
                max := mul;
                maxi := i;
                maxj := j;
            end;
           nVar += 1;
        end;
     end;
   WriteLn($' Всего палиндромов: {nVar}');
   WriteLn; 
   WriteLn($' Наибольший палиндром: {maxi} * {maxj} = {max}');
   WriteLn;   
end;


begin
   Writeln(' Project Euler. Problem 4');
   WriteLn;
   
   //Solve();
   Solve2();   
end.
