﻿uses MathExtensions;

// строка цифр:
var
   str := '73167176531330624919225119674426574742355349194934' +
          '96983520312774506326239578318016984801869478851843' +
          '85861560789112949495459501737958331952853208805511' +
          '12540698747158523863050715693290963295227443043557' +
          '66896648950445244523161731856403098711121722383113' +
          '62229893423380308135336276614282806444486645238749' +
          '30358907296290491560440772390713810515859307960866' +
          '70172427121883998797908792274921901699720888093776' +
          '65727333001053367881220235421809751254540594752243' +
          '52584907711670556013604839586446706324415722155397' +
          '53697817977846174064955149290862569321978468622482' +
          '83972241375657056057490261407972968652414535100474' +
          '82166370484403199890008895243450658541227588666881' +
          '16427171479924442928230863465674813919123162824586' +
          '17866458359124566529476545682848912883142607690042' +
          '24219022671055626321111109370544217506941658960408' +
          '07198403850962455444362981230987879927244284909188' +
          '84580156166097919133875499200524063689912560717606' +
          '05886116467109405077541002256983155200055935729725' +
          '71636269561882670428252483600823257530420752963450';
// число сомножителей:
var
   k := 13;//5;
   

// РЕШАЕМ ЗАДАЧУ ПРОСТЫМ СПОСОБОМ
procedure SolveSimple();
begin
   // наибольшее произведение:
   var bigMul: int64 := 0;
   // начальный индекс:
   var maxId := 0;
   // находим произведение всех групп 
   // из k чисел в строке:
   for var i := 1 to str.Length - k do begin
       var mul: int64 := 1;
       // находим произведение первых k чисел:
       for var j := 0 to k - 1 do begin
           //mul *= integer.Parse(str[i+j].ToString());
          mul *= (Ord(str[i + j]) - Ord('0'));
       end;
      // печатаем текущее произведение:
      //WriteLn(mul);
      if (mul > bigMul) then begin
         bigMul := mul;
         maxId := i;
      end
   end;
   Writeln($' Наибольшее произведение = {bigMul}');
   Writeln($' Начинается с индекса      {maxId}');   
   Writeln;
end;


function SolveSubstr(s: string): int64;
begin
   var res: int64 := 1;
   var max: int64 := 0;
   var maxId := 0;
   // находим произведение первых k чисел:
   for var i := 1 to k do
      res *= (Ord(s[i]) - Ord('0'));

   // запоминаем результат:
   max := res;
   // начало диапазона из k чисел:
   var ptr := 1;
   
   while (ptr + k <= s.Length) do begin
      // делим произведение на 
      // первое число диапазона:
      res := res div (Ord(s[ptr]) - Ord('0'));
      // и умножаем на следующее
      // за концом диапазона:
      res *= (Ord(s[ptr + k]) - Ord('0'));
      if (res > max) then begin
         max := res;
         maxId := ptr;
      end;
      ptr += 1;
   end;
   Result := max;
end;


// РЕШАЕМ ЗАДАЧУ
procedure Solve();
begin
   // разбиваем исходную строку на подстроки,
   // не содержащие нулей:
   var astr := str.Split(|'0'|);   
   // наибольшее произведение:
   var bigMul: int64 := 0;
   
   // находим макс. произведение в каждой строке:
   foreach var s in astr do begin
      // если подстрока короче k,
      // то пропускаем её:
      if (s.Length < k) then
         continue;
      //Write(s + ' > ');
      var mul := SolveSubstr(s);
      //WriteLn(mul);
      if (mul > bigMul) then
         bigMul := mul;
   end;
   Writeln($' Наибольшее произведение = {bigMul}'); 
   Writeln;
end;


procedure CreateString(len : integer);
begin
    Randomize;
    var sb := new StringBuilder(len);
    for var i := 0 to len-1 do begin
        var n := Random(10);
        sb.Append(n);
    end;
    str := sb.ToString();
end;


begin
   Writeln(' Project Euler. Problem 8');
   WriteLn;
   // формируем строку цифр:
   //CreateString(10000000);
   var start := Milliseconds();
   SolveSimple();
   WriteLn($' Метод SolveSimple: {Milliseconds - start} ms');
   WriteLn;               
   start := Milliseconds();  
   Solve();
   WriteLn($' Метод Solve:       {Milliseconds - start} ms');
   WriteLn;                   
end.
