﻿uses MathExtensions;
  
const 
    OneThousand = 1000;
    OneMillion = 1000000;
    OneBillion = 1000000000;  

var words := new Dictionary<int64, string>;
procedure CreateDict();
begin
  words.Add(0, 'zero'); 
  words.Add(1, 'one'); 
  words.Add(2, 'two');
  words.Add(3, 'three'); 
  words.Add(4, 'four'); 
  words.Add(5, 'five');
  words.Add(6, 'six'); 
  words.Add(7, 'seven'); 
  words.Add(8, 'eight');
  words.Add(9, 'nine'); 
  words.Add(10, 'ten'); 
  words.Add(11, 'eleven');
  words.Add(12, 'twelve'); 
  words.Add(13, 'thirteen'); 
  words.Add(14, 'fourteen');
  words.Add(15, 'fifteen'); 
  words.Add(16, 'sixteen'); 
  words.Add(17, 'seventeen');
  words.Add(18, 'eighteen'); 
  words.Add(19, 'nineteen'); 
  words.Add(20, 'twenty');
  words.Add(30, 'thirty'); 
  words.Add(40, 'forty'); 
  words.Add(50, 'fifty');
  words.Add(60, 'sixty'); 
  words.Add(70, 'seventy'); 
  words.Add(80, 'eighty');
  words.Add(90, 'ninety'); 
  words.Add(100, 'hundred'); 
  words.Add(1000, 'thousand');
  words.Add(1000000, 'million'); 
  words.Add(1000000000, 'billion');
end;

function NumberToWords(number: int64): string;
begin
  if number < 0 then
    Result := 'negative ' + NumberToWords(-number)
  else if number < 20 then
    Result := words[number]
  else if number < 100 then
  begin
    var tens := (number div 10) * 10;
    var units := number mod 10;
    Result := words[tens];
    if units > 0 then
      Result := Result + '-' + words[units];
  end
  else if number < 1000 then
  begin
    var hundreds := number div 100;
    var remainder := number mod 100;
    Result := words[hundreds] + ' hundred';
    if remainder > 0 then
      Result := Result + ' and ' + NumberToWords(remainder);
  end
  else if number < 1000000 then
  begin
    var thousands := number div 1000;
    var remainder := number mod 1000;
    Result := NumberToWords(thousands) + ' thousand';
    if remainder > 0 then
    begin
      if remainder < 100 then
        Result := Result + ' and ' + NumberToWords(remainder)
      else
        Result := Result + ', ' + NumberToWords(remainder);
    end;
  end
  else if number < 1000000000 then
  begin
    var millions := number div 1000000;
    var remainder := number mod 1000000;
    Result := NumberToWords(millions) + ' million';
    if remainder > 0 then
      Result := Result + ', ' + NumberToWords(remainder);
  end
  else
  begin
    var billions := number div 1000000000;
    var remainder := number mod 1000000000;
    Result := NumberToWords(billions) + ' billion';
    if remainder > 0 then
      Result := Result + ', ' + NumberToWords(remainder);
  end;
end;

        
// РЕШАЕМ ЗАДАЧУ
procedure Solve();
begin
   CreateDict;
   var totalLetters := 0;
   for var i := 1 to 1000 do begin
       var words := NumberToWords(i)
      .Replace(' ', '')
      .Replace('-', '')
      .Replace(',', '');
       totalLetters += words.Length;
   end;
   Writeln($' Всего букв в числах 1-1000: {totalLetters}');
   Writeln;   
end;


begin
   Writeln(' Project Euler. Problem 17');
   Writeln;
       
   Solve();  
end.
