﻿uses MathExtensions;
  
const 
    Тысяча = 1000;
    Миллион = 1000000;
    Миллиард = 1000000000;

var слова := new Dictionary<int64, string>;
procedure CreateDict();
begin
  слова.Add(0, 'ноль'); 
  слова.Add(1, 'один'); 
  слова.Add(2, 'два');
  слова.Add(3, 'три'); 
  слова.Add(4, 'четыре'); 
  слова.Add(5, 'пять');
  слова.Add(6, 'шесть'); 
  слова.Add(7, 'семь'); 
  слова.Add(8, 'восемь');
  слова.Add(9, 'девять'); 
  слова.Add(10, 'десять'); 
  слова.Add(11, 'одиннадцать');
  слова.Add(12, 'двенадцать'); 
  слова.Add(13, 'тринадцать'); 
  слова.Add(14, 'четырнадцать');
  слова.Add(15, 'пятнадцать'); 
  слова.Add(16, 'шестнадцать'); 
  слова.Add(17, 'семнадцать');
  слова.Add(18, 'восемнадцать'); 
  слова.Add(19, 'девятнадцать'); 
  слова.Add(20, 'двадцать');
  слова.Add(30, 'тридцать'); 
  слова.Add(40, 'сорок'); 
  слова.Add(50, 'пятьдесят');
  слова.Add(60, 'шестьдесят'); 
  слова.Add(70, 'семьдесят'); 
  слова.Add(80, 'восемьдесят');
  слова.Add(90, 'девяносто'); 
  слова.Add(100, 'сто'); 
  слова.Add(200, 'двести');
  слова.Add(300, 'триста'); 
  слова.Add(400, 'четыреста'); 
  слова.Add(500, 'пятьсот');
  слова.Add(600, 'шестьсот'); 
  слова.Add(700, 'семьсот'); 
  слова.Add(800, 'восемьсот');
  слова.Add(900, 'девятьсот'); 
  слова.Add(1000, 'тысяча'); 
  слова.Add(1000000, 'миллион');
  слова.Add(1000000000, 'миллиард');
end;


function NumberToRussianWords(number: int64): string;
begin  
  if number < 0 then
    Result := 'минус ' + NumberToRussianWords(-number)
  else if number < 20 then
    Result := слова[number]
  else if number < 100 then
  begin
    var десятки := (number div 10) * 10;
    var единицы := number mod 10;
    Result := слова[десятки];
    if единицы > 0 then
      Result := Result + ' ' + слова[единицы];
  end
  else if number < 1000 then
  begin
    var сотни := (number div 100) * 100;
    var остаток := number mod 100;
    Result := слова[сотни];
    if остаток > 0 then
      Result := Result + ' ' + NumberToRussianWords(остаток);
  end
  else if number < 1000000 then
  begin
    var тысячи := number div 1000;
    var остаток := number mod 1000;
    
    // Склонение тысяч
    var тысСлово := 'тысяч';
    if (тысячи mod 10 = 1) and (тысячи mod 100 <> 11) then
      тысСлово := 'тысяча'
    else if (тысячи mod 10 in [2..4]) and not (тысячи mod 100 in [12..14]) then
      тысСлово := 'тысячи';
    
    Result := NumberToRussianWords(тысячи) + ' ' + тысСлово;
    if остаток > 0 then
      Result := Result + ' ' + NumberToRussianWords(остаток);
  end
  else
    Result := 'очень большое число';
end;

        
// РЕШАЕМ ЗАДАЧУ
procedure Solve();
begin
   CreateDict;
   var totalLetters := 0;
   for var i := 1 to 1000 do begin
       var words := NumberToRussianWords(i)
      .Replace(' ', '')
      .Replace('-', '')
      .Replace(',', '');
       totalLetters += words.Length;
   end;
   Writeln($' Всего букв в числах 1-1000: {totalLetters}');
   Writeln;   
end;


begin
   Writeln(' Project Euler. Problem 17rus');
   Writeln;
       
   Solve();  
end.
