﻿uses MathExtensions;
  
// числовая пирамида:
var triangle :=  
        |'75',
        '95 64',
        '17 47 82',
        '18 35 87 10',
        '20 04 82 47 65',
        '19 01 23 75 03 34',
        '88 02 77 73 07 63 67',
        '99 65 04 28 06 16 70 92',
        '41 41 26 56 83 40 80 70 33',
        '41 48 72 33 47 32 37 16 94 29',
        '53 71 44 65 25 43 91 52 97 51 14',
        '70 11 33 28 77 73 17 78 39 68 17 57',
        '91 71 52 38 17 14 91 43 58 50 27 29 48',
        '63 66 04 68 89 53 67 30 73 16 69 87 40 31',
        '04 62 98 27 23 09 70 98 73 93 38 53 60 04 23'|;
        
// РЕШАЕМ ЗАДАЧУ
procedure Solve();
begin
   // построчный список чисел:
   var rows := new List<List<int>>();
   foreach var s in triangle do begin
      // разбиваем строку на отдельные "слова":
      var wrd := s.Split(' ');
      var lst := new List<int>();
      foreach var w in wrd do begin
         var num := int.Parse(w);
         lst.Add(num);
      end;
      rows.Add(lst);
   end;
  
   // макс. сумма:
   var maxs := 0;
   // число строк в треугольнике:
   var nRows := rows.Count();
   // список текущих макс. значений сумм:
   var maxValues := new int[nRows];

   // макс. значения сумм в последней строке =
   // числам в этой строке:
   for var i := 0 to nRows-1 do
       maxValues[i] := rows[nRows - 1][i];

   for var r := nRows - 2 downto 0 do
       for var c := 0 to r do begin
           maxValues[c] := rows[r][c] + 
           Max(maxValues[c], maxValues[c + 1]);
       end;

   maxs := maxValues[0];
   Writeln($' Максимальная сумма = {maxs}');   
   Writeln;   
end;


begin
   Writeln(' Project Euler. Problem 18');
   Writeln;
       
   Solve();  
end.
