﻿uses MathExtensions, System;
         
// РЕШАЕМ ЗАДАЧУ
procedure Solve();
begin
   var count := 0;
   for var year := 1901 to 2000 do
       for var month := 1 to 12 do begin
           // создаём дату - первое число месяца:
           var dt := new DateTime(year, month, 1);
           // проверяем на воскресенье:
           if dt.DayOfWeek = DayOfWeek.Sunday then
              count += 1;
    end;
   Writeln($' Число воскресений = {count}');   
   Writeln;  
end;


procedure Solve2();
begin
  var count := Range(1901, 2000)
              .SelectMany(year -> Range(1, 12)
              .Select(month -> new DateTime(year, month, 1)))
              .Count(dt -> dt.DayOfWeek = DayOfWeek.Sunday);
   Writeln($' Число воскресений = {count}');   
   Writeln;  
end;


function GetSundayFirsts(startYear, endYear: integer): sequence of DateTime;
begin
   for var year := startYear to endYear do
       for var month := 1 to 12 do begin
           var dt := new DateTime(year, month, 1);
           if dt.DayOfWeek = DayOfWeek.Sunday then
              yield dt;
       end;
end;
procedure Solve3();
begin
   var sundays := GetSundayFirsts(1901, 2000).ToArray;
   Writeln($' Число воскресений = {sundays.Length}');   
   Writeln;  
   
   for var i := 0 to sundays.Length - 1 do
       Writeln('  ', sundays[i].ToString('dd.MM.yyyy'));
   Writeln;  
end;


function IsSunday(year, month, day: int): bool;
begin
   // Алгоритм Зеллера для определения дня недели
   // Возвращает 0=суббота, 1=воскресенье, ..., 6=пятница
  
   if month < 3 then begin
      month := month + 12;
      year := year - 1;
   end;
  
   var K := year mod 100;
   var J := year div 100;
  
   var h := (day + ((13 * (month + 1)) div 5) + 
             K + (K div 4) + (J div 4) + 
             5 * J) mod 7;
  
   // h = 1 - воскресенье:
   Result := h = 1;
end;
procedure Solve4;
begin
  var count := 0;
  for var year := 1901 to 2000 do
      for var month := 1 to 12 do
          if IsSunday(year, month, 1) then
             count += 1;
   Writeln($' Число воскресений = {count}');   
   Writeln;  
end;


begin
   Writeln(' Project Euler. Problem 19');
   Writeln;
       
   Solve();  
   Solve2();    
   Solve3();   
   Solve4();    
end.
