﻿uses MathExtensions;

function SumOfDivisors(n: int): int;
begin
  if n < 2 then exit(0);
  
  // 1 всегда делитель:
  var sum := 1; 
  var limit := ISqrt(n);
  
  for var i := 2 to limit do begin
     if n mod i = 0 then begin
        sum += i;
        var complement := n div i;
        if complement <> i then
           sum := sum + complement;
     end;
  end;
  Result := sum;
end;


const limit = 10000;        
// РЕШАЕМ ЗАДАЧУ
procedure Solve;
begin
   var totalSum := 0;
  
   // вычисляем суммы делителей для всех чисел:
   var divisorSums : array[0..limit + 1] of int;
   for var a := 2 to limit do
       divisorSums[a] := SumOfDivisors(a);
  
    // дружественные пары:
    Writeln($' Дружественные числа до {limit}:');
    Writeln(' -----------------------------');
  
    for var a := 2 to limit do begin
        var  b := divisorSums[a];
        if (b > a) and (b <= limit) then begin
            if divisorSums[b] = a then begin
               Writeln($' {a} и {b}');
               totalSum += a + b;
            end;
        end;
  end;
  
  Writeln(' -----------------------------');
  Writeln($' Сумма: {totalSum}');
end;


begin
   Writeln(' Project Euler. Problem 21');
   Writeln;
       
   Solve();    
end.
