﻿uses MathExtensions;

function AlphabeticalValue(name: string): int;
begin
  Result := 0;
  foreach var ch in name do
     Result += Ord(ch) - Ord('A') + 1;
end;


function ParseNames(text: string): List<string>;
begin
   Result := new List<string>;
   var name := '';
   var inQuotes := false;
  
   for var i := 1 to text.Length do begin
       var ch := text[i];
       case ch of
           '"': begin
                   if inQuotes then begin
                      // закрывающая кавычка:
                      if name.Length > 0 then begin
                         Result.Add(name);
                         name := '';
                      end;
                  end;
                  inQuotes := not inQuotes;
              end;
        
          'A'..'Z':
              if inQuotes then
                 name += ch;  
       // остальные символы пропускаем
       end;
    end;
end;


// РЕШАЕМ ЗАДАЧУ
procedure Solve();
begin
   var path := 'p022_names.txt';
   var text := ReadAllLines(path)[0];
   
   var names := ParseNames(text);
   Writeln('Найдено имен: ', names.Count);
   
   // сортируем:
   names.Sort;
   //foreach var n in names do
   //       println(n.Length,n);
   
   // для проверки печатаем первые 5 имен:
   Writeln('Первые 5 имен после сортировки:');
   for var i := 0 to Min(4, names.Count - 1) do
       Writeln($'  {i + 1}: {names[i]}');

   // вычисляем результат:
   var totalScore: int64 := 0;
   for var i := 0 to names.Count - 1 do
       totalScore += AlphabeticalValue(names[i]) * (i + 1);
  
   Writeln;
   Writeln($' Суммарный результат: {totalScore}');
   // правильный ответ: 871198282   
   Writeln;   
end;


begin
   Writeln(' Project Euler. Problem 22');
   Writeln;
       
   Solve();  
end.
