﻿uses MathExtensions;


// ВОЗВРАЩАЕТ СУММУ ВСЕХ ДЕЛИТЕЛЕЙ ЧИСЛА,
// КРОМЕ САМОГО ЧИСЛА
function SumOfDivisors(n: int) :=  n.Divisors.Sum - n;

// ИЗБЫТОЧНОЕ ЧИСЛО?
function IsAbundant(n: int) := SumOfDivisors(n) > n;


// РЕШАЕМ ЗАДАЧУ
procedure Solve();
begin
   var limit := 28123;
  
   // все избыточные числа до limit:
   var abundantNumbers := new List<int>;
   // 12 - первое избыточное число:
   for var i := 12 to limit do 
       if IsAbundant(i) then
          abundantNumbers.Add(i);
  
    Writeln($' Найдено избыточных чисел: {abundantNumbers.Count}');
    Writeln(' Первые 10 избыточных чисел:');
    for var i := 0 to Min(9, abundantNumbers.Count - 1) do
        Write($' {abundantNumbers[i]} ');
    Writeln;
  
    // отмечаем все числа, 
    // которые можно представить как сумму двух избыточных:
    var canBeExpressed := new bool[limit + 1];
  
    for var i := 0 to abundantNumbers.Count - 1 do
        for var j := i to abundantNumbers.Count - 1 do begin
            var sum := abundantNumbers[i] + abundantNumbers[j];
            if sum <= limit then
               canBeExpressed[sum] := true;
    end;
  
    // суммируем числа, 
    // которые нельзя выразить как сумму двух избыточных:
    var totalSum := 0;
    var count := 0;
  
    for var i := 1 to limit do
        if not canBeExpressed[i] then  begin
           totalSum += i;
           count += 1;
        end;
  
    Writeln;
    Writeln($' Всего таких чисел: {count}');
    Writeln($' Их сумма = {totalSum}');
    Writeln;
  // ответ: 4179871
end;

begin
   Writeln(' Project Euler. Problem 23');
   Writeln;
       
   Solve();  
end.
