﻿
uses MathExtensions;


// СКОЛЬКО ПОСЛЕДОВАТЕЛЬНЫХ ПРОСТЫХ ЧИСЕЛ ДАЕТ ФОРМУЛА N2 + AN + B,
// НАЧИНАЯ С N = 0
function CountPrimes(a, b: integer): integer;
begin
   // счётчик:
   var n := 0;
   while true do begin
      var num := n*n + a*n + b;
      if not num.IsPrime then break;
      n += 1;
  end;
  // кол-во последовательных простых чисел:
  Result := n;  
end;       
         
         
// РЕШАЕМ ЗАДАЧУ
procedure Solve;
begin  
   // лучшие значения:  
   var maxPrimes := 0;
   var bestA := 0;
   var bestB := 0;
  
  // все простые числа b в диапазоне [-1000, 1000]:
  var primeBs := new List<int>;
  for var b := 2 to 1000 do
      if b.IsPrime then  
         primeBs.Add(b);
  Writeln($' Простые b в диапазоне [-1000, 1000]: {primeBs.Count}');
  
   // перебираем все возможные a и b:
   for var a := -999 to 999 do begin
       for var i := 0 to primeBs.Count - 1 do begin
           var b := primeBs[i];
          
           // подсчитываем, простые числа
           // для этих значений:
           var primesCount := CountPrimes(a, b);
           // обновляем рекорд:
           if primesCount > maxPrimes then begin
              maxPrimes := primesCount;
              bestA := a;
              bestB := b;
              // печатаем лучшие результаты:
              Writeln($' Новый максимум: a = {a,4}, b = {b,4}, простых чисел: {primesCount,3}, произведение: {a*b,6}');
          end;
       end;
   end;
  
  Writeln;
  Writeln('=' * 70);
  Writeln(' РЕЗУЛЬТАТ:');
  Writeln($' a = {bestA}');
  Writeln($' b = {bestB}');
  Writeln($' Кол-во последовательных простых чисел = {maxPrimes}');
  Writeln($' Произведение a × b = {bestA * bestB}');
  Writeln('=' * 70);
  
   // проверяем решение:
   Writeln;
   Writeln($' Проверка формулы n² + {bestA}n + {bestB}:');
   for var n := 0 to maxPrimes - 1 do begin
       var num := n*n + bestA*n + bestB;
       Writeln($' n = {n,2}: {n*n,4} + {bestA*n,5} + {bestB,5}  = {num,6} ({num.IsPrime})');
   end; 
end;


begin
   Writeln(' Project Euler. Problem 27');
   WriteLn;
       
   Solve;   
end.
