﻿uses MathExtensions;

             
// РЕШАЕМ ЗАДАЧУ
procedure Solve;
begin  
   // номиналы монет в пенсах:
   var coins := |1, 2, 5, 10, 20, 50, 100, 200|;
   var target := 200; // 2 фунта = 200 пенсов
  
   // массив для динамического программирования -->
   // ways[i] - количество способов набрать сумму i пенсов:
   var ways := new int64[target + 1];
   // 1 способ набрать 0 пенсов - не брать монеты:
   ways[0] := 1; 

   // динамическое программирование:
   foreach var coin in coins do begin
      for var amount := coin to target do 
          ways[amount] += ways[amount - coin];
   end;
  
   Writeln($' Количество способов = {ways[target]}');
   // 73682
end;


begin
   Writeln(' Project Euler. Problem 31');
   WriteLn;
       
   Solve;      
end.
