﻿
uses MathExtensions;


// СТРОКА СОСТОИТ ИЗ РАЗНЫХ ЦИФР?
function IsPandigital(s : string) : bool;
begin
   Result := (s.Length = 9) and 
             (not s.Contains('0')) and 
             (s.Distinct().Count() = 9);
end;   
   

// РЕШАЕМ ЗАДАЧУ
procedure Solve();
begin
   // сумма произведений:
   var sum: int64 := 0;
   // множество для отсеивания повторяющихся произведений:
   var hs: HashSet<int> := [];

   // решаем задачу -->
   // перебираем первые сомножители:
   for var n1 := 2 to 99 do begin
       // второй сомножитель:
       var n2min := (n1 > 9) ? 123 : 1234;
       var n2max := 9999 div n1;
       // перебираем вторые сомножители:
       for var n2 := n2min to n2max do begin
           // находим произведение:
           var product := n1 * n2;
           // составляем строку из трёх чисел:
           var s := '' + n1 + n2 + product;
           // в строке есть повторы?
           if not IsPandigital(s) then continue;
           // для информации печатаем правильные произведения:
           Println($' {n1,2} x {n2,4} = {product,5}');

           // произведения не должны повторяться:
           if hs.Contains(product) then continue;
           // добавляем в множество новое произведение:
           hs.Add(product);
           // добавляем произведение в сумму:
           sum += product;
       end;
   end;
   // печатаем ответ:
   Println($' Сумма равна: {sum}');
   WriteLn;
end;


begin
   Writeln(' Project Euler. Problem 32');
   WriteLn;

   Solve(); 
end.