﻿uses MathExtensions;


// ПРОВЕРЯЕМ ДРОБЬ ВИДА ab/cd
function IsCuriousFraction(a, b, c, d: int): bool;
begin
   // избегаем деления на 0:
   if (b = 0) or (d = 0) then exit(false); 
   // тривиальные случаи:
   if (a = b) or (c = d) then exit(false); 
  
   // числитель:
   var originalNumerator := 10*a + b;
   // знаменатель:
   var originalDenominator := 10*c + d;
   // дробь должна быть < 1:
   if originalNumerator >= originalDenominator then 
      exit(false); 
  
   // дробь:
   var originalValue := originalNumerator / originalDenominator;
  
   // пробуем сократить, если есть общая цифра
   var simplifiedValue: real;
   // сокращаем первую цифру (a и c):
   if (a = c) then
       simplifiedValue := b / d
   // сокращаем a и d:
   else if (a = d) then   
       simplifiedValue := b / c
   // сокращаем b и c:
   else if (b = c) then   
       simplifiedValue := a / d
   // сокращаем b и d:
   else if (b = d) then   
       simplifiedValue := a / c
   // нет общих цифр:
   else exit(false); 
  
   // проверяем дроби на равенство:
   //Result := Abs(originalValue - simplifiedValue) < 1e-10;
   Result := originalValue = simplifiedValue;   
end;


// РЕШАЕМ ЗАДАЧУ
procedure Solve;
begin 
  // список дробей: 
    var curiousFractions := new List<(int, int, int, int)>;
  
   // перебираем все возможные дроби ab/cd:
   for var a := 1 to 9 do
       for var b := 0 to 9 do
           for var c := a + 1 to 9 do // a < c, чтобы дробь была < 1
               for var d := 0 to 9 do begin
                   if IsCuriousFraction(a, b, c, d) then
                      curiousFractions.Add((a, b, c, d));
               end;
  
    Writeln($' Найдено любопытных дробей: ', curiousFractions.Count);
    
    var productNumerator := 1;
    var productDenominator := 1;
    
    foreach var (a, b, c, d) in curiousFractions do begin
       var num := 10*a + b;
       var den := 10*c + d;
       var val := num / den;
       var s: String;
       if a = c then s := $'{b}/{d}'
       else if a = d then s := $'{b}/{c}'
       else if b = c then s := $'{a}/{d}'
       else s := $'{a}/{c}';
       Writeln($' {num}/{den} = {s}');
       productNumerator *= num;
       productDenominator *= den;
    end;
    
    // сокращаем произведение:
    var gcdValue := Gcd(productNumerator, productDenominator);
    var simplifiedNum := productNumerator div gcdValue;
    var simplifiedDen := productDenominator div gcdValue;
    
    Writeln;
    Writeln($' Произведение всех дробей = {productNumerator}/{productDenominator}');
    Writeln($' После сокращения: {simplifiedNum}/{simplifiedDen}');
    Writeln($' Знаменатель дроби = {simplifiedDen}');
    // 100
end;



begin
   Writeln(' Project Euler. Problem 33');
   WriteLn;
       
   Solve;      
end.
