﻿uses MathExtensions;


function GetRotations(n: int): array of int;
begin
   var s := n.ToString;
   SetLength(Result, s.Length);
  
   for var i := 0 to s.Length - 1 do begin
       var rotated := s.Substring(i) + s.Substring(0, i);
       Result[i] := StrToInt(rotated);
   end;
end;


function IsCircularPrime(n: int): bool;
begin
   var rotations := GetRotations(n);
   foreach var rot in rotations do
      if not (rot.IsPrime) then
         exit(false);
  Result := true;
end;


// РЕШАЕМ ЗАДАЧУ
procedure Solve;
begin 
   var limit := 1_000_000;
   var count := 0;
   var circularPrimes := new List<int>;
   
   // проверяем все числа:
   for var n := 2 to limit - 1 do begin
       if IsCircularPrime(n) then begin
          count += 1;
          circularPrimes.Add(n);
       end;
   end;
   // печатаем найденные числа:
   foreach var i in circularPrimes do begin
      Writeln(i:6);
   end;
   Writeln;
   Writeln($' Всего круговых простых чисел < {limit}: {count}');
   // 55
end;


begin
   Writeln(' Project Euler. Problem 35');
   WriteLn;
       
   Solve;      
end.
