﻿uses MathExtensions;


function IsBinaryPalindrome(n: int): bool;
begin
   // конвертируем число в двоичную строку без ведущих нулей:
   var binary := '';
   var temp := n;
   while temp > 0 do begin
      binary := (temp mod 2).ToString + binary;
      temp := temp div 2;
   end;
   // проверяем, является ли двоичная строка палиндромом:
   var len := binary.Length;
   for var i := 1 to len div 2 do 
       if binary[i] <> binary[len - i + 1] then
          exit(false);
   Result := true;
end;


// РЕШАЕМ ЗАДАЧУ
procedure Solve;
begin 
   var limit := 1_000_000;
   var sum := 0;
   var numbersFound := new List<int>;
  
   // проверяем все числа от 1 до limit-1
   for var n := 1 to limit - 1 do begin
       if n.IsPalindrome and IsBinaryPalindrome(n) then begin
          sum += n;
          numbersFound.Add(n);
       end;
   end;
   Writeln($' Найдено чисел: {numbersFound.Count}');
   Writeln;
  
   // печатаем все найденные числа:
   foreach var n in numbersFound do begin
      // двоичное представление:
      var binary := '';
      var temp := n;
      while temp > 0 do begin
         binary := (temp mod 2).ToString + binary;
         temp := temp div 2;
      end;
      Writeln($' {n,6} (десятичное) = {binary.PadLeft(20)} (двоичное)');
   end;
   Writeln;
   Writeln($' Сумма всех чисел = {sum}');
   // 872187
end;


begin
   Writeln(' Project Euler. Problem 36');
   WriteLn;
       
   Solve;      
end.
