﻿uses MathExtensions;


// ПРОВЕРЯЕМ ЗАДАННОЕ ЧИСЛО НА УСЕКАЕМОСТЬ
function IsTruncatablePrime(n: integer): boolean;
begin
   // число не простое:
   if not (n.IsPrime) then exit(false);
  
   var s := n.ToString;
   var len := s.Length;
  
   // однозначное число:
   if len < 2 then exit(false);
  
   // усекаем число справа налево 
   // (удаляем последнюю цифру):
   var temp := n;
   while temp > 9 do begin
      temp := temp div 10;
      if not (temp.IsPrime) then exit(false);
   end;
  
   // усекаем число слева направо 
   // (удаляем первую цифру)
   temp := n;
   while temp > 9 do begin
     var power := 1;
     while power * 10 <= temp do
        power *= 10;
     temp := temp mod power;
     if not (temp.IsPrime) then exit(false);
   end;
   Result := true;
end;


// РЕШАЕМ ЗАДАЧУ
procedure Solve;
begin 
   var count := 0;
   var sum := 0;
   var numbersFound := new List<integer>;
  
   // первые 4 простых числа пропускаем:
   var n := 11;
  
   // всего существует 11 таких чисел:
   while count < 11 do begin
      // нашли:
      if IsTruncatablePrime(n) then begin
         count += 1;
         sum += n;
         numbersFound.Add(n);
         Writeln;
         Writeln($' Нашли усекаемое простое число {count,2}: {n}');
      
        // процесс усечения найденного числа&
        Write(' Усечение справа: ');
        var temp := n;
        while temp > 0 do begin
           Write(temp);
           temp := temp div 10;
           if temp > 0 then Write(' → ');
        end;
        Writeln;
        Write(' Усечение слева: ');
        temp := n;
        while temp > 0 do begin
           Write(temp);
           var power := 1;
           while power * 10 <= temp do
                 power *= 10;
           temp := temp mod power;
           if temp > 0 then Write(' → ');
        end;
        Writeln;
      end;
      // считаем найдёнышей:
      n += 1;
   end;
  
   Writeln;
   Writeln(' Всего найдено усекаемых простых чисел: ', count);
   Writeln;
   Write(' Числа: ');
   foreach var num in numbersFound do
      Write(num, ' ');
   Writeln;
  
   Writeln(' Сумма всех усекаемых простых чисел =', sum);
   // 748317
end;


begin
   Writeln(' Project Euler. Problem 37');
       
   Solve;      
end.
