﻿
uses MathExtensions;


// СТРОКА СОСТОИТ ИЗ РАЗНЫХ ЦИФР?
function IsPandigital(s : string) : bool;
begin       
    Result :=  (s.Length = 9) and
               (s.All(c -> c <> '0')) and 
               (s.Distinct().Count() = 9);  
end;   
   

// РЕШАЕМ ЗАДАЧУ
procedure Solve();
begin
   // наибольшее число:
   var maxnum: int64 := 0;

   // решаем задачу -->
   // перебираем первые сомножители:
   for var i := 1 to 9999 do begin
       // строка для сложения произведений:
       var str := String.Empty;
       // второй сомножитель:
       var n := 1;
       // последовательно складываем произведения, пока
       // в строке меньше девяти цифр:
       while (str.Length < 9) do begin
          str += i * n;
          n += 1;
       end;

       // нашли пандигитальное число:
       if IsPandigital(str) then begin
          var num := Convert.ToInt64(str);
          // запоминаем, если оно больше текущего значения:
          if (num > maxnum) then
              maxnum := num;
          // печатаем промежуточные результаты:
          Println($' {i,4}, {n-1} → {str}');
      end;
   end;
   // печатаем ответ:
   Println($' Наибольшее число = {maxnum}');
   WriteLn;
end;


procedure Solve2();
begin
   // наибольшее число:
   var maxstr := String.Empty;

   // решаем задачу -->
   // перебираем первые сомножители:
   for var i := 1 to 9999 do begin
       // строка для сложения произведений:
       var str := String.Empty;
       // второй сомножитель:
       var n := 1;
       // последовательно складываем произведения, пока
       // в строке меньше девяти цифр:
       while (str.Length < 9) do begin
          str += i * n;
          n += 1;
       end;

       // нашли пандигитальное число:
       if IsPandigital(str) then begin
          if (str.CompareTo(maxstr) > 0) then
              maxstr := str;
          // печатаем промежуточные результаты:
          Println($' {i,4}, {n-1} → {str}');
      end;
   end;
   // печатаем ответ:
   Println($' Наибольшее число = {maxstr}');
   WriteLn;
end;


begin
   Writeln(' Project Euler. Problem 38');
   WriteLn;

   Solve(); 
   Solve2();    
end.