﻿uses MathExtensions;

// ПРОВЕРЯЕМ УСЛОВИЕ ЗАДАЧИ  
function Uslovie(num: string): bool;
begin
   // простые делители:
   var primeDivisors := |2, 3, 5, 7, 11, 13, 17|;
   // проверяем для всех делителей:
   for var i := 0 to primeDivisors.Length - 1 do begin
       var snum3 := num.Slice(i + 1, 1, 3);
       if snum3.Length < 3 then break;
       var num3 := snum3.ToInteger;
       //println(num, snum3,num3);
       // не делится на очередное простое число:
       if num3 mod primeDivisors[i] <> 0 then
          exit(false);
   end;
   // число выдержало все проверки:
   Result := true;
end;


// РЕШАЕМ ЗАДАЧУ
procedure Solve();
begin
   // решаем задачу -->
   var res := '0123456789'.Permutations         // генерируем перестановки
                          .Where(Uslovie)       // отбираем строки, удовлетворяющие условию 
                          .Select(int64.Parse); // конвертируем строку в число
   // печатаем все числа,
   // для которых выполняется условие задачи:
   foreach var n in res do
      Println($' Число = {n}');

   // находим сумму этих чисел:
   var sum := res.Sum();       

   // печатаем ответ:
   Println($' Сумма = {sum}');
   WriteLn;
end;


begin
   Writeln(' Project Euler. Problem 43');
   WriteLn;

   Solve();     
end.