﻿uses MathExtensions;
         
// РЕШАЕМ ЗАДАЧУ
procedure Solve();
begin
   var path := 'p067_triangle.txt';
   var triangle := ReadAllLines(path);
   
   // построчный список чисел:
   var rows := new List<List<int>>();
   foreach var s in triangle do begin
      // разбиваем строку на отдельные "слова":
      var wrd := s.Split(' ');
      var lst := new List<int>();
      foreach var w in wrd do begin
         var num := int.Parse(w);
         lst.Add(num);
      end;
      rows.Add(lst);
   end;
  
   // макс. сумма:
   var maxs := 0;
   // число строк в треугольнике:
   var nRows := rows.Count();
   // список текущих макс. значений сумм:
   var maxValues := new int[nRows];

   // макс. значения сумм в последней строке =
   // числам в этой строке:
   for var i := 0 to nRows-1 do
       maxValues[i] := rows[nRows - 1][i];

   for var r := nRows - 2 downto 0 do
       for var c := 0 to r do begin
           maxValues[c] := rows[r][c] + 
           Max(maxValues[c], maxValues[c + 1]);
       end;

   maxs := maxValues[0];
   Writeln($' Максимальная сумма = {maxs}');   
   Writeln;   
end;


begin
   Writeln(' Project Euler. Problem 67');
   Writeln;
       
   Solve();  
end.
