﻿uses MathExtensions;

// ПРОВЕРЯЕМ ЧИСЛО НА ПАНДИГИТАЛЬНОСТЬ
{
function IsPandigital(n: int64): bool;
begin
   var s := n.ToString();
   Result := s.OrderBy(c -> c).SequenceEqual('123456789');
end;
}
        
// РЕШАЕМ ЗАДАЧУ
procedure Solve();
begin
   // первые числа Фибоначчи:
   var f1: BigInteger := 1;
   var f2: BigInteger := 1;
   // номер текущего числа Фибоначчи:
   var k := 2;

   // решаем задачу:
   while true do begin
      k += 1;
      //if k mod 1000 = 0 then Println($' k = {k}');
      // текущее число Фибоначчи:
      var current := f1 + f2;
      (f2, f1) := (f1, current);
      //f2 := f1;
      //f1 := current;

      // проверяем последние 9 цифр:
      var last9 := current mod 1_000_000_000;
      if not IsPandigital(int64(last9)) then 
         continue;
      // проверяем первые 9 цифр:
      var fs := current.ToString();
      if fs.Length < 9 then 
         continue;
      var fs9 := fs.Substring(0, 9);
      var first9 := int.Parse(fs9);
      if not IsPandigital(first9) then
         continue;
      // печатаем ответ:
      Println($' k = {k}');     
      writeln;
      break;
   end;
end;


begin
   Writeln(' Project Euler. Problem 104');
   WriteLn;

   Solve();     
end.