﻿unit BigIntegerExtensions;


interface
{$reference System.Numerics.dll}
uses System.Numerics;

type
  BigIntegerEx = static class
  public

  end;

implementation

/// ВОЗВРАЩАЕТ ФАКТОРИАЛ ЗАДАННОГО ЧИСЛА
function FactorialBig(self: Integer): BigInteger; extensionmethod;
begin
   if self < 0 then
      raise new System.ArgumentOutOfRangeException('Factorial is not defined for negative numbers');
  
   if self = 0 then exit(1);
  
   Result := 1;
   var i := BigInteger(1);
  
   while i <= self do begin
         Result := Result * i;
         i := i + 1;
   end;
end;


/// ВЫДАЁТ ПОСЛЕДОВАТЕЛЬНОСТЬ ФАКТОРИАЛОВ
function FactorialSequence(n: integer): sequence of BigInteger;
begin
   if n < 0 then
      raise new System.ArgumentOutOfRangeException('Число не может быть отрицательным!');
  
   var fact := BigInteger(1);
   yield fact;
   for var i := 1 to n do begin
       fact := fact * i;
       yield fact;
  end;
end;


/// МЕТОД РАСШИРЕНИЯ ДЛЯ ЦЕЛЫХ ЧИСЕЛ
function FactorialSequence(self: integer): sequence of BigInteger; extensionmethod;
begin
  Result := FactorialSequence(self);
end;



    /// ВОЗВРАЩАЕТ ЦИФРЫ ЧИСЛА
    function GetDigitsBig(self: BigInteger): sequence of integer; extensionmethod;
    begin
      if self = 0 then begin
        yield 0;
        exit;
      end;
      
      var num := BigInteger.Abs(self);
      var digits := new List<integer>;
      
      while num > 0 do begin
         var dig := BigInteger.Remainder(num, 10); 
         num := BigInteger.Divide(num, 10);       
         digits.Add(integer(dig));
      end;
      
      for var i := digits.Count - 1 downto 0 do
        yield digits[i];
    end;
    
    
    /// ВОЗВРАЩАЕТ КОЛИЧЕСТВО ЦИФР ЧИСЛА
    function DigitCountBig(self: BigInteger): integer; extensionmethod;
    begin
      if self = 0 then
        Result := 1
      else
        Result := integer(BigInteger.Log10(BigInteger.Abs(self))) + 1;
    end;
    
    
    /// ВОЗВРАЩАЕТ СУММУ ЦИФР ЧИСЛА
    function DigitSumBig(self: BigInteger): integer; extensionmethod;
    begin
      Result := 0;
      foreach var digit in self.GetDigitsBig do
         Result := Result + digit;
    end;
    
    
    /// ВОЗВРАЩАЕТ ПРОИЗВЕДЕНИЕ ЦИФР ЧИСЛА
    function DigitProductBig(self: BigInteger): BigInteger; extensionmethod;
    begin
      Result := 1;
      foreach var digit in self.GetDigitsBig do
        Result := Result * digit;
    end;
    
    
    /// ВОЗВРАЩАЕТ TRUE, ЕСЛИ ЧИСЛО - ПАЛИНДРОМ
    function IsDigitPalindromeBig(self: BigInteger): boolean; extensionmethod;
    begin
      var digits := self.GetDigitsBig.ToArray;
      var len := digits.Length;
      
      for var i := 0 to len div 2 do
        if digits[i] <> digits[len - 1 - i] then
          Exit(false);
      
      Result := true;
    end;
    
    
    /// ВОЗВРАЩАЕТ ПЕРВУЮ ЦИФРУ ЧИСЛА
    function FirstDigitBig(self: BigInteger): integer; extensionmethod;
    begin
      if self = 0 then
        Result := 0
      else
      begin
        var num := BigInteger.Abs(self);
        while num >= 10 do
          num := num div 10;
        Result := integer(num);
      end;
    end;
    
    
    /// ВОЗВРАЩАЕТ ПОСЛЕДНЮЮ ЦИФРУ ЧИСЛА
    function LastDigitBig(self: BigInteger): integer; extensionmethod;
    begin
      if self = 0 then
        Result := 0
      else
        Result := integer(BigInteger.Abs(self) mod 10);
    end;
    
    /// ВОЗВРАЩАЕТ КАЖДУЮЦИФРУ ЧИСЛА В ЗАДАННОЙ СТЕПЕНИ
    function GetDigitPowersBig(self: BigInteger; power: integer): sequence of BigInteger; extensionmethod;
    begin
       foreach var digit in self.GetDigitsBig do
          yield BigInteger.Pow(digit, power);
   end;
   
   /// ВОЗВРАЩАЕТ TRUE, ЕСЛИ ЧИСЛО АРМСТРОНГА
   function IsArmstrongNumber(self: BigInteger; power: integer): boolean; extensionmethod;
   begin
      var sum := self.GetDigitPowersBig(power).Sum;
      Result := sum = self;
   end;

end.