﻿uses MathExtensions;

// ГЕНЕРИРУЕТ ВСЕ КОМБИНАЦИИ ИЗ k ЭЛЕМЕНТОВ ЗАДАННОЙ КОЛЛЕКЦИИ
function GetCombinations<T>(elements: array of T; k: int): sequence of array of T;
begin
   var n := elements.Length;
   if k > n then exit;
  
   // инициализируем индексы:
   var indices := ArrGen(k, i -> i);
  
   while true do begin
      // создаём комбинацию по текущим индексам:
      var combination := new T[k];
      for var i := 0 to k - 1 do
          combination[i] := elements[indices[i]];
     yield combination;
    
     // следующий набор индексов:
     var i := k - 1;
     while (i >= 0) and (indices[i] = n - k + i) do
            i := i - 1;
     // комбинации закончились:
     if i < 0 then break; 
    
     indices[i] := indices[i] + 1;
     for var j := i + 1 to k - 1 do
         indices[j] := indices[j - 1] + 1;
     end;
end;


// Гарри
procedure Harry();
begin
   // множество допустимых цифр для Гарри:
   var digits := new HashSet<char>('01234');
   // множество подходящих квадратов:
   var squares := new HashSet<string>();

   // ищем среди чисел, которые дают пятизначные квадраты:
   var minNum := ISqrt(10000); // 100
   var maxNum := ISqrt(44444); // 210
   for var i := minNum to maxNum do begin
       // пятизначные квадраты:
       var sn := (i * i).ToString();
       // последняя цифра не 0:
       if (sn[^1] = '0') then continue;
       // не все цифры:
       if not sn.All(digits.Contains) then continue;
       // добавляем квадрат в множество:
       squares.Add(sn);
       // печатаем квадрат на экране:
       Writeln($' Гарри: {i}^2 = {sn}')
   end;

   // каждая цифра должна встречаться 5, 6, 7, 8 или 9 раз:
   var r: HashSet<int> := [ 5, 6, 7, 8, 9 ];
   // нужно выбрать 7 чисел
   // каждое число из 5 цифр → 35 / 5 = 7
   var n := r.Sum div 5;

   // перебираем все комбинации из 7 чисел:
   foreach var combo in GetCombinations(squares.ToArray, n) do begin
      // собираем числа в строку:
      var combined := string.Join('', combo);
      // считаем, сколько раз встречается каждая цифра
      // в словаре получаем пары: цифра, частота:
      var counter := combined.GroupBy(c -> c)
                             .ToDictionary(g -> g.Key, g -> g.Count());

      // проверяем: множество частот должно совпадать с {5,6,7,8,9}
      if (counter.Values
                 .ToHashSet()
                 .SetEquals(r)) then 
      begin
         // сортируем числа:
         var sortedChosen := combo.OrderBy(x -> x);
         // находим невыбранные числа как разность множеств:
         var notChosen := squares.Except(combo)
                                 .OrderBy(x -> x);

         // печатаем ответ для Гарри:
         var str := string.Join(', ', sortedChosen);
         Writeln($' Гарри выбрал: {str}');
         Writeln($' Гарри не выбрал: {notChosen.First}');
         Writeln;
      end;
   end;
end;
 

// Том
procedure Tom();
begin
   // множество допустимых цифр для Тома:
   var digits := new HashSet<char>('56789');
   // множество подходящих квадратов:
   var squares := new HashSet<string>();

   // перебираем числа, которые дают пятизначные квадраты:
   var minNum := ISqrt(50000); // 236
   var maxNum := ISqrt(99999); // 316
   for var i := minNum to maxNum do begin
       var sn := (i * i).ToString();
       if not sn.All(digits.Contains) then continue;

       squares.Add(sn);
       // печатаем квадрат на экране:
       Writeln($' Том: {i}^2 = {sn}')
   end;
   // каждая цифра должна встречаться 1, 2, 3 или 4 раза:
   var r: HashSet<int> := [ 1, 2, 3, 4 ];
   // нужно выбрать 2 числа
   // каждое число из 5 цифр → 10 / 5 = 2
   var n := r.Sum() div 5;

   // перебираем все комбинации из 2-х чисел:
   foreach var combo in GetCombinations(squares.toArray, n) do begin
      var combined := string.Join('', combo);
      var counter := combined.GroupBy(c -> c)
                             .ToDictionary(g -> g.Key, g -> g.Count());
      // проверяем: множество частот должно совпадать с {1, 2, 3, 4}
      if counter.Values.ToHashSet().SetEquals(r) then begin
         var sortedChosen := combo.OrderBy(x -> x);
         var notChosen := squares.Except(combo).OrderBy(x -> x);

         // печатаем ответ для Тома:
         var str := string.Join(', ', sortedChosen);
         Writeln($' Том выбрал: {str}');
         str := string.Join(', ', notChosen);
         Writeln($' Том не выбрал: {str}');
         Writeln;
      end;   
   end;
end;
        
        
begin
   Writeln(' Enigma 1504: All ten digits');
   Writeln;
       
   // отвечаем на вопрос 1:
   Harry();
   // отвечаем на вопрос 2:
   Tom();    
end.
