﻿unit FibonacciBigInt;

interface

{$reference System.Numerics.dll}
uses System.Numerics;

type
  Fibonacci = static class
  public
    /// Возвращает n-ое число Фибоначчи (F₀ = 0, F₁ = 1)
    class function Get(n: integer): BigInteger;
    /// Генерирует последовательность чисел Фибоначчи
    class function SequenceFibo(): sequence of BigInteger;
    /// Возвращает последовательность с индексами
    class function SequenceWithIndex(): sequence of (integer, BigInteger);
  end;

implementation

class function Fibonacci.Get(n: integer): BigInteger;
begin
  if n <= 0 then exit(BigInteger.Zero);
  if n = 1 then exit(BigInteger.One);
  
  var a := BigInteger.Zero;
  var b := BigInteger.One;
  
  for var i := 2 to n do
  begin
    var temp := a + b;
    a := b;
    b := temp;
  end;
  
  Result := b;
end;


/// ГЕНЕРИРУЕТ БОЛЬШИЕ ЧИСЛА ФИБОНАЧЧИ
class function Fibonacci.SequenceFibo(): sequence of BigInteger;
begin
  var a := BigInteger.Zero;
  var b := BigInteger.One;
  
  yield a;  // F₀
  yield b;  // F₁
  
  while true do
  begin
    var next := a + b;
    yield next;
    a := b;
    b := next;
  end;
end;


class function Fibonacci.SequenceWithIndex(): sequence of (integer, BigInteger);
begin
  var index := 0;
  var a := BigInteger.Zero;
  var b := BigInteger.One;
  
  yield (index, a);  // F₀
  index += 1;
  yield (index, b);  // F₁
  
  while true do
  begin
    index += 1;
    var next := a + b;
    yield (index, next);
    a := b;
    b := next;
  end;
end;

end.