﻿// MathExtensions.pas
unit MathExtensions;

interface

{$reference System.Numerics.dll}
uses System.Numerics;
uses System;

type
   int = integer;
   bool = boolean;


function GetFibo(): sequence of BigInteger;
function GetFiboMax(maxf: int): sequence of int;
function GetFiboMaxBI(maxf: BigInteger): sequence of BigInteger;
function GetFiboN(num: int): sequence of BigInteger;

function GetFactN(num: int): sequence of BigInteger;
function GetFactorialN(num: int): sequence of Integer;
function Factorial(num: integer): integer;

function IsQuadrat(num: decimal): boolean;

function Permutation(n: integer): array[,] of integer;

function IsPandigital(n: int64): bool;
function IsPandigital0To9(n: int64): bool;

function LCMArray(numbers: array of integer): int64;

function GeneratePrimes(): sequence of int64; 
function PythagoreanTriplesGen(maxC: int): sequence of (int, int, int);
function OptimizedPrimeGen(limit: int64): sequence of int64;
/// <summary>Целое число в целую степень (включая отрицательную)</summary>
//function Power(n: integer; exponent: integer): real;

function GetSortedDivisors(n: int64): sequence of int64;

function Tri(n : int): int64;

function Summa(num: BigInteger): int64;
function Summa(num: int64): int64;

    
implementation

function FastPower(base: real; exp: integer): real;
begin
  if exp = 0 then Result := 1
  else if exp mod 2 = 0 then 
    Result := FastPower(base * base, exp div 2)
  else 
    Result := base * FastPower(base, exp - 1);
end;
function Power(self: real; exponent: integer := 2): real; extensionmethod;
begin
  if (self = 0) and (exponent <= 0) then
    raise new System.ArgumentException('Недопустимая операция 0^' + exponent);
  
  if exponent = 0 then Result := 1
  else if exponent > 0 then Result := FastPower(self, exponent)
  else Result := 1 / FastPower(self, -exponent);
end;

// МЕТОДЫ РАСШИРЕНИЯ ДЛЯ КЛАССА INTEGER

// МЕТОД РАСШИРЕНИЯ ДЛЯ ТИПА int
// ВОЗВРАЩАЕТ ЧИСЛО num В СТЕПЕНИ exponent
function IPower(self: integer; exponent: integer := 2): int64; extensionmethod;
begin
   var pow: int64 := 1;
   loop exponent do pow *= self;
           Result := pow;
end;
        
{
function IPower(self: integer; exponent: integer := 2)
begin
  if (self = 0) and (exponent <= 0) then
    raise new System.ArgumentException('Недопустимая операция 0^' + exponent);
  
  if exponent = 0 then Result := 1
  else Result := FastPower(self, exponent)
end;
}


//ОПРЕДЕЛЯЕМ ЯВЛЯЕТСЯ ЛИ ЗАДАННОЕ ЧИСЛО 
//ПОЛНЫМ КВАДРАТОМ

{function int64.IsQuadrat(): boolean;
begin
   var r := Trunc(Math.Sqrt(self));
   Result := r * r = self;
end;}


// ОПРЕДЕЛЯЕМ ЯВЛЯЕТСЯ ЛИ ЗАДАННОЕ ЧИСЛО ЧЁТНЫМ
function  IsEven(Self: int64): bool; extensionmethod;
begin
   Result := self mod 2 = 0;
end;

// ОПРЕДЕЛЯЕМ ЯВЛЯЕТСЯ ЛИ ЗАДАННОЕ ЧИСЛО НЕЧЁТНЫМ
function IsOdd(Self: int64): bool; extensionmethod;
begin
   Result := self mod 2 <> 0;
end;


function IsQuadrat(Self: int64): bool; extensionmethod;
begin
   var r := Trunc(Sqrt(self));
   Result := r * r = self;
end;

function ISqrt(Self: int64): int64; extensionmethod;
begin
   Result := Trunc(Sqrt(self));
end;

{function int.IsQuadrat(): boolean;
begin
   var r := Trunc(Math.Sqrt(self));
   Result := r * r = self;
end;
}
function IsQuadrat(Self: integer): boolean; extensionmethod;
begin
   var r := Trunc(Sqrt(self));
   Result := r * r = self;
end;



//ОПРЕДЕЛЯЕМ ЯВЛЯЕТСЯ ЛИ ЗАДАННОЕ ЧИСЛО 
//ПОЛНЫМ КВАДРАТОМ
function IsQuadrat(num: decimal): boolean;
begin
   var r := Trunc(Sqrt(double(num)));
   Result := r * r = num;
end;

//ОПРЕДЕЛЯЕМ ЯВЛЯЕТСЯ ЛИ ЗАДАННОЕ ЧИСЛО 
//ПОЛНЫМ КУБОМ
{function int64.IsCube(): boolean;
begin
   var r := Trunc(Math.Round(Math.Pow(self, 1.0 / 3.0)));
   Result := r * r * r = self;
end;}

function IsCube(Self: int64): boolean; extensionmethod;
begin
   var r := Trunc(Round(Power(self, 1.0 / 3.0)));
   Result := r * r * r = self;
end;

{function int.IsCube(): boolean;
begin
   var r := Trunc(Math.Round(Math.Pow(self, 1.0 / 3.0)));
   Result := r * r * r = self;
end;}

function IsCube(Self: integer): boolean; extensionmethod;
begin
   var r := Trunc(Round(Power(self, 1.0 / 3.0)));
   Result := r * r * r = self;
end;


// целое число?
function IsInteger(Self: real): boolean; extensionmethod;
begin
   Result := self = Trunc(self);
end;


//  ЧИСЛА-ПАЛИНДРОМЫ
function int64.IsPalindrome(): boolean;
begin
  	// избавляемся от чисел, заканчивающихся на нуль:
   if ((self <> 0) and (self mod 10 = 0)) then
        exit(false);
   
   var rev: int64 := 0;
   var num := self;
   while (num >= rev) do begin
      rev := 10 * rev + num mod 10;		
      if (num = rev) then
      begin
         Result := true;
         exit;
      end;
      
      num := num div 10;
      if (num = rev) then
      begin
         Result := true;
         exit;
      end;
   end;
   Result := false;
end;

function IsPalindrome(Self: int): bool; extensionmethod;
begin
  	// избавляемся от чисел, заканчивающихся на нуль:
   if ((self <> 0) and (self mod 10 = 0)) then
        exit(false);
   
   var rev := 0;
   var num := self;
   while (num >= rev) do begin
      rev := 10 * rev + num mod 10;		
      if (num = rev) then exit(true);
      num := num div 10;
      if (num = rev) then exit(true);
   end;
   Result := false;
end;


function BigInteger.IsPalindrome(): bool;
begin
   var rev: BigInteger := 0;
   var num := self;
   while (num >= rev) do
   begin
      rev := 10 * rev + num mod 10;
      if (num = rev) then
      begin
         Result := true;
         exit;
      end;
      
      num := num div 10;
      
      if (num = rev) then
      begin
         Result := true;
         exit;
      end;
   end;
   Result := false;
end;


// ПЕРЕВОРАЧИВАЕМ ЧИСЛО
function ReverseNum(Self: integer): integer; extensionmethod;
begin
   var rev := 0;
   var num := self;    
   while (num > 0) do
   begin
      rev := rev * 10 + num mod 10;
      num := num div 10;
   end;
   Result := rev;
end;

function ReverseNum(Self: BigInteger): BigInteger; extensionmethod;
begin
   var rev: BigInteger := 0;
   var num := self;    
   while (num > 0) do
   begin
      rev := rev * 10 + num mod 10;
      num := num div 10;
   end;
   Result := rev;
end;




// НАХОДИМ ЧИСЛО ЦИФР В ЗАДАННОМ ЧИСЛЕ
function NumDigit(Self: int64): integer; extensionmethod;
begin
   var num := Abs(self);
   var nd := 0;
   while (num > 0) do
   begin
      nd += 1;
      num := num div 10;
   end;
   Result := Max(1, nd);
end;

function NumDigit(Self: integer): integer; extensionmethod;
begin
   var num := Abs(self);
   var nd := 0;
   while (num > 0) do
   begin
      nd += 1;
      num := num div 10;
   end;
   Result := Max(1, nd);
end;

// ВСЕ ЦИФРЫ ЗАДАННОГО ЧИСЛА
{function GetDigits(Self: integer): sequence of integer; extensionmethod;
begin
   var num := Abs(self);
   while (num > 0) do
   begin
      var dig:= num mod 10;
      num := num div 10;     
      yield dig;
   end;
end;}

function GetDigits(Self: int): sequence of int; extensionmethod;
begin
   var res := Range(0,-1);
   var num := Abs(self);
   while (num > 0) do begin
      var dig:= num mod 10;
      num := num div 10;     
      res := res + dig;
   end;
   Result := res.Reverse;
end;


// ВОЗВРАЩАЕТ СУММУ ЦИФР ЗАДАННОГО ЧИСЛА типа BigInteger
function Summa(num: BigInteger): int64;
begin
   var  sum := BigInteger(0);
   while (num > 0) do begin
        sum += num mod 10;
        num := num div 10;
   end;
   Result := int64(sum);
end;

function Summa(num: int64): int64;
begin
   var  sum := 0;
   while (num > 0) do begin
      sum += num mod 10;
      num := num div 10;
   end;
   Result := sum;
end;



// ПРОВЕРЯЕМ ЧИСЛО НА ПРОСТОТУ
function IsPrime(Self: integer): bool; extensionmethod;
begin
   var num := self;
   if num > 1 then  begin
      Result := Range(2, Trunc(Sqrt(num)))
               .All(divisor -> num mod divisor <> 0)
   end
   else Result := false;
end;


// ПРОВЕРЯЕМ ЧИСЛО С ЦИФРАМИ 1.. 9 НА ПАНДИГИТАЛЬНОСТЬ
function IsPandigital(n: int64): bool;
begin
   var s := n.ToString();
   Result := s.OrderBy(c -> c)
              .SequenceEqual('123456789');
end;
// ПРОВЕРЯЕМ ЧИСЛО С ЦИФРАМИ 0.. 9 НА ПАНДИГИТАЛЬНОСТЬ
function IsPandigital0To9(n: int64): bool;
begin
   // в числе должно быть 10 цифр 0..9:
   var s := n.ToString();
   Result := s.OrderBy(c -> c)
              .SequenceEqual('0123456789');
end;

//                ФАКТОРИЗАЦИЯ
{
// ПРОСТЫЕ ДЕЛИТЕЛИ
// без повторения одинаковых делителей!
function GetPrimeFactors(Self: integer): sequence of int; extensionmethod;
begin
   var num := self;
   Result := PABCSystem.Range(2, Trunc(Sqrt(num)))
                       .Where(divisor -> (num mod divisor = 0) and (divisor.IsPrime))
end;

function int64.GetPrimeFactors(): sequence of int;
begin
   var num := self;   
   Result := PABCSystem.Range(2, Trunc(Sqrt(num)))
                       .Where(divisor -> (num mod divisor = 0) and (divisor.IsPrime))
end;
}
{
function GetPrimeFactorsRep(Self: integer): sequence of int; extensionmethod;
begin
   var factors := new List<int>();
   var n := Self;
   if (n = 1) then
       factors.Add(1)
   else
   begin
      var factor := 2;
      var step := 2;

      while (factor * factor <= n) do
      begin
         if (n mod factor = 0) then
         begin
            factors.Add(factor);
            n := factor;
         end
         else if (factor < 3) then
         begin
            factor += 1;
         end
         else if (factor < 5) then
         begin
            factor += 2;
         end
         else
         begin
            factor += step;
            step := 6 - step;
         end;
      end;
      factors.Add(n);
   end;
   Result:= factors;
end;
}

// ПРОСТЫЕ ДЕЛИТЕЛИ
// с повторением одинаковых делителей!
function GetPrimeFactorsRep(Self: integer): sequence of int; extensionmethod;
begin   
   var n := Self;
   if (n = 1) then
       yield 1
   else
   begin
      var factor := 2;
      var step := 2;

      while (factor * factor <= n) do
      begin
         if (n mod factor = 0) then
         begin
            yield factor;
            n := n div factor;
         end
         else if (factor < 3) then
         begin
            factor += 1;
         end
         else if (factor < 5) then
         begin
            factor += 2;
         end
         else
         begin
            factor += step;
            step := 6 - step;
         end;
      end;
      yield n;
   end;
end;
     

// ВСЕ ДЕЛИТЕЛИ
// без повторения одинаковых делителей!
function GetFactors(Self: int): sequence of int; extensionmethod;
begin
   var num := self;   
   Result := PABCSystem.Range(2, Trunc(Sqrt(num)))
                       .Where(divisor -> num mod divisor = 0)
end;

function int64.GetFactors(): sequence of int;
begin
   var num := self;   
   Result := PABCSystem.Range(2, Trunc(Sqrt(num)))
                       .Where(divisor -> num mod divisor = 0)
end;


function GetPrimeFactors(Self: int64): sequence of int; extensionmethod;
begin   
   Result := Self.GetFactors.Where(n -> n.IsPrime);
end;


// ВОЗВРАЩАЕТ ВСЕ ОТСОРТИРОВАННЫЕ ДЕЛИТЕЛИ ЧИСЛА ТИПА int64
function GetSortedDivisors(n: int64): sequence of int64;
begin
  if n = 0 then begin
    yield 0;
    exit;
  end;
  
  n := Abs(n);
  // список делителей:
  var divisors := new List<int64>;
  
  if n = 1 then begin
    divisors.Add(1);
  end
  else begin
    divisors.Add(1);
    for var i := 2 to Trunc(Sqrt(n)) do begin
      if n mod i = 0 then begin
        divisors.Add(i);
        var complement := n div i;
        if complement <> i then
           divisors.Add(complement);
      end;
    end;
    divisors.Add(n);
  end;
  // сортируем и возвращаем:
  divisors.Sort;
  foreach var d in divisors do
    yield d;
end;

// МЕТОД РАСШИРЕНИЯ ДЛЯ ТИПА integer
// ВОЗВРАЩАЕТ ВСЕ ДЕЛИТЕЛИ ЧИСЛА,
// ВКЛЮЧАЯ САМО ЧИСЛО
function Divisors(self: int): sequence of int; extensionmethod;
begin
   var n := Abs(self);
   // возвращаем 1:      
   yield 1;
   if n = 1 then exit;
      
   // возвращаем делители 2.. < n:        
   for var i := 2 to ISqrt(n) do begin
       if n mod i = 0 then begin
          yield i;
          var complement := n div i;
          if complement <> i then
             yield complement;
      end;
   end;
   // возвращаем само число:
   yield n;
end;
    
    
    // ВОЗВРАЩАЕТ ВСЕ ДЕЛИТЕЛИ ЧИСЛА ТИПА int64
    function Divisors(self: int64): sequence of int64; extensionmethod;
    begin
      var n := Abs(self);
      
      yield 1;
      if n = 1 then exit;
      
      for var i := 2 to Trunc(Sqrt(n)) do begin
          if n mod i = 0 then begin
             yield i;
             var complement := n div i;
             if complement <> i then
                yield complement;
          end;
      end;
      yield n;
end;


function GetProperDivisors(n: int64): sequence of int64;
begin
  // Собственные делители (все делители кроме самого числа)
  if n <= 1 then exit;
  
  yield 1;
  
  for var i := 2 to Trunc(Sqrt(n)) do
  begin
    if n mod i = 0 then
    begin
      yield i;
      
      var complement := n div i;
      if (complement <> i) and (complement <> n) then
        yield complement;
    end;
  end;
end;

function GetPrimeDivisors(n: int64): sequence of int64;
begin
  // Только простые делители
  if n <= 1 then exit;
  
  var temp := n;
  var divisor := 2;
  
  while temp > 1 do
  begin
    if temp mod divisor = 0 then
    begin
      yield divisor;
      while temp mod divisor = 0 do
        temp := temp div divisor;
    end;
    
    if divisor = 2 then
      divisor := 3
    else
      divisor := divisor + 2;
      
    if divisor * divisor > temp then
    begin
      if temp > 1 then
        yield temp;
      break;
    end;
  end;
end;


// ВОЗВРАЩАЕТ ЧИСЛО ВСЕХ ДЕЛИТЕЛЕЙ ЧИСЛА
function DivisorCount(self: int64): integer; extensionmethod;
begin
   if self = 0 then
      exit(0); // бесконечное число
      
      var n := Abs(self);
      var count := 2; // 1 и само число
      
      for var i := 2 to Trunc(Sqrt(n)) do begin
          if n mod i = 0 then begin
             count := count + 1; // i 
          if i * i <> n then
             count := count + 1; // n div i
        end;
      end;
   Result := count;
end;
    
    


/// Бесконечный генератор простых чисел
function  GeneratePrimes(): sequence of int64; 
begin
   yield 2;
   var primes := Lst(2);

   var candidate: int64 := 3;
   while True do begin
      var isPrime := true;
      var limit := int64(Sqrt(candidate));

      foreach var p in primes do begin
         if (p > limit) then break;
         if (candidate mod p = 0) then begin
            isPrime := false; 
            break; 
         end;
      end;

      if (isPrime) then begin
          primes.Add(candidate);
          yield candidate;
      end; 
      // проверяем только нечётные:
      candidate += 2; 
   end;
end;

/// Быстрый генератор простых чисел
function OptimizedPrimeGen(limit: int64): sequence of int64;
begin
   if limit < 2 then exit;
  
   // создаём массив размером limit+1:
   var isPrime := new boolean[limit + 1];
   for var i := 2 to limit do 
       isPrime[i] := true;
   // первое простое число:
   yield 2; 
  
   // только нечётные числа:
   var sqrtLimit := Trunc(Sqrt(limit));
  
   for var i := 3 to sqrtLimit step 2 do begin
       if isPrime[i] then begin
          // начинаем с i*i, шаг = 2*i
          // (только нечётные кратные):
          var step := i * 2;
          var j := i * i;
          while j <= limit do begin
                isPrime[j] := false;
                j += step;
          end;
      end;
  end;
  
  // возвращаем оставшиеся простые числа:
  for var i := 3 to limit step 2 do
      if isPrime[i] then
         yield i;
end;


//          ЧИСЛА ФИБОНАЧЧИ

/// ГЕНЕРАТОР ЧИСЕЛ ФИБОНАЧЧИ
function GetFibos(): sequence of int64;
{
  Writeln(' Первые 20 чисел Фибоначчи:');
  foreach var n in GetFibos.Take(20) do
    Write(n, ' ');
}
begin
   // первая пара чисел Фибоначчи:
   var a : int64 := 0;
   var b : int64 := 1;
   //var a : int64 := 1;
   //var b : int64 := 2;   
   while True do begin
      yield a;
      (a, b) := (b, (a + b));
   end;
end;


function GetFiboBig: sequence of BigInteger;
begin
  var a := BigInteger(0);
  var b := BigInteger(1);
  
  while True do begin
    yield a;
    var temp := a + b;
    a := b;
    b := temp;
  end;
end;

        
function Fibonacci(self: integer): sequence of integer;
begin
  if self <= 0 then exit;
  var (a, b) := (0, 1);
  for var i := 1 to self do begin
    yield a;
    (a, b) := (b, a + b);
  end;
end;

function GetFibo(): sequence of BigInteger;
begin
   var a: BigInteger := 0;
   var b: BigInteger := 1;
   while true do
   begin
      yield a;
      (a, b) := (b, a + b);
   end;
end;

function GetFiboMaxBI(maxf: BigInteger): sequence of BigInteger;
begin
   var a: BigInteger := 0;
   var b: BigInteger := 1;
   while (a <= maxf) do
   begin
      yield a;
      (a, b) := (b, a + b);
   end;
end;

function GetFiboMax(maxf: int): sequence of int;
begin
   var a: int := 0;
   var b: int := 1;
   while (a <= maxf) do
   begin
      yield a;
      (a, b) := (b, a + b);
   end;
end;

function GetFiboN(num: int): sequence of BigInteger;
begin
   var a: BigInteger := 0;
   var b: BigInteger := 1;
   foreach var i in Range(1, num) do
   begin
      yield a;
      (a, b) := (b, a + b);
   end;
end;


// ВЫЧИСЛЯЕМ ФАКТОРИАЛ
function GetFactN(num: int): sequence of BigInteger;
begin
   var n: BigInteger := 1;
   foreach var i in Range(1, num) do begin
      n := i * n;
      yield n;
   end;
end;

function GetFactorialN(num: int): sequence of Integer;
begin
   yield 1;
   var n := 1;
   foreach var i in Range(1, num) do begin
      n := i * n;
      yield n;
   end;
end;


function Factorial(num: int): int;
begin
   var fact := 1;
   for var i := 1 to num do
      fact *= i;	
   Result := fact;
end;

function Factorial(Self: int): int; extensionmethod;
begin
   var fact := 1;
   for var i := 1 to Self do
      fact *= i;	
   Result := fact;
end;





// ТРЕУГОЛЬНЫЕЧИСЛА

// НЕРЕКУРСИВНАЯ ФУНКЦИЯ
function Tri(n : int): int64;
begin
    if (n <= 1) then begin
        Result := n;
        exit;
    end;
    Result := n * (n + 1) div 2;
end;


//    ПЕРЕСТАНОВКИ

//ГЕНЕРИРУЕМ ПЕРЕСТАНОВКИ
function Permutation(n: integer): array[,] of integer;
begin
   //число перестановок:
   var AllPerm := Factorial(n);
   //массив перестановок:
   var perms := new integer[AllPerm, n];
   
   //текущее число перестановок:
   var nPerm := 0;
   
   //массив чисел:
   var a := new integer[n + 2];
   //начальная перестановка:
   for var e := 1 to n do
      a[e] := e;
   
   var j: integer;
   repeat
      for var id := 1 to n do
         perms[nPerm, id - 1] := a[id];
      
      nPerm += 1;     
      var i := n;
      while (a[i - 1] > a[i]) do 
         i -= 1;
      j := i - 1;
      var h := a[j];
      
      while (a[i + 1] > h) do
         i += 1;
      a[j] := a[i];  
      a[i] := h;
      i := j + 1; 
      var k := n;
      while (i < k) do
      begin
         h := a[i]; 
         a[i] := a[k]; 
         a[k] := h;
         i += 1;
         k -= 1;               
      end
   until not (j <> 0);
   
   Result := perms;
end;



// ПЕЧАТАЕМ ЧИСЛО ТИПА integer
{
function Println(Self: integer): integer; extensionmethod;
begin
   Println(Self);   
   Result := Self;
end;

// ПЕЧАТАЕМ ЧИСЛО ТИПА BigInteger
function Println(Self: BigInteger): BigInteger; extensionmethod;
begin
   Println(Self);   
   Result := Self;
end;

// ПЕЧАТАЕМ ЧИСЛО ТИПА int64
function Println(Self: int64): int64; extensionmethod;
begin
   Println(Self);   
   Result := Self;
end;
}
// ПЕЧАТАЕМ СПИСОК
function Println<T>(Self: List<T>): List<T>; extensionmethod;
begin
   Println(Self);   
   Result := Self;
end;

/// Декартово произведение двух последовательностей
/// к каждой паре элементов этих последовательностей
/// применяется функция resultSelector
function Cartesian<T, T1>(Self: sequence of T; 
                         b: sequence of T1;
                         resultSelector: Func<T, T1, T> ): sequence of T; extensionmethod;
begin
   if b = nil then
      raise new System.ArgumentNullException('b');
   if (resultSelector = nil) then
      raise new System.ArgumentNullException('resultSelector');
   
   foreach var x in Self do
      foreach var y in b do
         yield resultSelector(x, y)
end;

// ВОЗВРАЩАЕТ КВАДРАТЫ ЧИСЕЛ
function Squares(Self: sequence of integer): sequence of int64; extensionmethod;
begin
   foreach var i in Self do
      yield int64(i) * i;
end;

/// ВОЗВРАЩАЕТ КУБЫ ЧИСЕЛ
function Cubes(Self: sequence of integer): sequence of int64; extensionmethod;
begin
   foreach var i in Self do
      yield int64(i) * i * i;
end;


/// ГЕНЕРИРУЕТ ПИФАГОРОВЫ ТРОЙКИ ЧИСЕЛ
function PythagoreanTriplesGen(maxC: int): sequence of (int, int, int);
begin
  for var m := 2 to Trunc(Sqrt(maxC)) + 1 do
      for var n := 1 to m - 1 do begin
          if (m - n) mod 2 = 1 then begin
              var a := m * m - n * n;
              var b := 2 * m * n;
              var c := m * m + n * n;
        
              if c <= maxC then begin
                 if a > b then Swap(a, b);
                 yield (a, b, c);
              end;
         end;
    end;
end;
function PythagoreanListTriplesGen(limit: integer): List<(int, int, int)>;
begin
  Result := new List<(int, int, int)>;
  
  for var m := 2 to Trunc(Sqrt(limit)) + 1 do
    for var n := 1 to m - 1 do
    begin
      if (m - n) mod 2 = 1 then begin
        var a := m * m - n * n;
        var b := 2 * m * n;
        var c := m * m + n * n;
        
        if c <= limit then begin
          if a > b then Swap(a, b);
          Result.Add((a, b, c));
        end;
      end;
    end;
  
   Result.Sort((t1, t2) -> t1.Item3.CompareTo(t2.Item3));
end;

function PythagoreanPrimeTriplesGen(maxC: int): sequence of (int, int, int);
begin
  for var m := 2 to Trunc(Sqrt(maxC)) + 1 do
      for var n := 1 to m - 1 do begin
          if ((m - n) mod 2 = 1) and (GCD(m, n) = 1) then begin
               var a := m * m - n * n;
               var b := 2 * m * n;
               var c := m * m + n * n;
        
              if c <= maxC then begin
                 if a > b then Swap(a, b);
                 yield (a, b, c);
              end;
         end;
    end;
end;

{function Where64(Self: sequence of int64; predicat: System.Func<int64,Boolean>): sequence of int64; extensionmethod;
begin
   foreach var i in Self do
      if predicat(i) then
         yield i;
end;}

/// НАИБОЛЬШИЙ ОБЩИЙ ДЕЛИТЕЛЬ ДВУХ ЧИСЕЛ
function GCD(a,b: int64)  : int64; 
begin 
   var (x, y) := (a, b); 
   while y <> 0 do (x, y) := (y, x mod y); 
   Result := x 
end;


/// НАИМЕНЬШЕЕ ОБЩЕЕ КРАТНОЕ ДВУХ ЧИСЕЛ
function LCM(a, b: int64): int64;
begin
  // Наименьшее общее кратное двух чисел
  // LCM(a,b) = |a*b| / GCD(a,b)
  if (a = 0) or (b = 0) then
    Result := 0
  else
    Result := Abs(a div GCD(a, b) * b);
end;


/// НАИМЕНЬШЕЕ ОБЩЕЕ КРАТНОЕ МАССИВА ЧИСЕЛ
function LCMArray(numbers: array of integer): int64;
begin
  if numbers.Length = 0 then
    raise new System.ArgumentException('Массив не может быть пустым');
    
  Result := numbers[0];
  for var i := 1 to numbers.Length - 1 do
      Result := LCM(Result, numbers[i]);
end;


function ToNumber(self: sequence of int): int64;  extensionmethod;
begin
   var num: int64 := 0;
   foreach var d in self do begin
       if (d < 0) or (d > 9) then
           raise new System.ArgumentException('Цифры должны быть в диапазоне 0–9!');
       num := num * 10 + d;
   end;
   Result := num;
end;

end.
